#ifndef WORLD_CLASSES_H
#define WORLD_CLASSES_H

#include <windows.h>

#define MAX_WALK 8
#define MAX_CAR 4

typedef DWORD Color;

struct Coord {
	float x;
	float y;
};

struct Percept {
	Color CarColor;
	float CarWidth;
	float CarLength;
	float CarDX;
	float CarDY;
	int CarAngle;		// 0-right, 1-up, 2-left, 3-down
	Color WalkerColor;
	float WalkerDX;
	float WalkerDY;
	float WalkerAngle;
	float RoadLength;
	float RoadWidth;
};

struct Action {
	bool PedalGas;
	bool PedalBrake;
	float WantVelocity;
	float WantAngle;
};

class Agent {
public:
	float x;
	float y;
	Color c;
};

class ReflexAgent: public Agent {};

class Pedestrian: public ReflexAgent {
public:
	float velocity;
	float angle;
	Coord *target1;
	Color target2;
	GenerateAction(Percept *percept,Action *action);
	Pedestrian(float x,float y,float angle,Color c);
};

class Automobile: public ReflexAgent {
public:
	float width;
	float length;
	float velocity;
	float coord;
	int road;		// 1 - horisontal, 2 - vertical
	bool orient;	// true - right/down, false - left/up
	CalcXY(float road_width);
	int GetAngle();
	GenerateAction(Percept *percept,Action *action);
	Automobile(float width,float length,Color c,int road,bool orient,float coord);
};

class EnvState {
public:
	float road_width;
	float road_length;
	float terr_size;
	Pedestrian *walkers[MAX_WALK];
	Automobile *cars[MAX_CAR];
	int time;
	Update(Action *actions);
};

class Environment {
public:
	EnvState state;
	HDC drawing;
	DWORD ttime;
	int timeout;
	Run();
	Environment(HDC dr);
	Redraw();
private:
	GetPercept(Agent *agent,Percept *percept);
};

#endif