#include "stdafx.h"

#include "Classes.h"
#include <math.h>

#define GetPercepts(STATE,K1,K2) {for (i=0;i<K1;i++) if (STATE.walkers[i]) GetPercept((STATE.walkers[i]),&(percepts[i])); for (i=0;i<K2;i++) if (STATE.cars[i]) GetPercept((STATE.cars[i]),&(percepts[K1+i]));}
#define GenActions(STATE,K1,K2) {for (i=0;i<K1;i++) if (STATE.walkers[i]) STATE.walkers[i]->GenerateAction(&(percepts[i]),&(actions[i])); for (i=0;i<K2;i++) if (STATE.cars[i]) STATE.cars[i]->GenerateAction(&(percepts[K1+i]),&(actions[K1+i]));}

#define FMin(A,B) ((A<B)?A:B)
#define FMax(A,B) ((A>B)?A:B)
#define Llim(X) ((X>0)?X:0)
#define Sign(X) ((X!=0)?((X)/fabs(X)):0)

//#define CalcCarXY(CAR) {switch (CAR.road) {case 1: CAR.x=CAR.coord; CAR.y=(CAR.orient?(-1):1)*CAR.env.road_width; break; case 2: CAR.x=(CAR.orient?(-1):1)*CAR.env.road_width; CAR.y=CAR.coord; break;}}

inline DistWithRoad(float x1,float x2,float w) {
	float c1=FMin(x1,x2);
	float c2=FMax(x1,x2);
	return (fabs(x1-x2)-Llim(FMin(c2,w/2)-FMax(c1,-w/2)))*Sign(x2-x1);
}

Environment::Run() {
	int i,j,k1,k2;
	k1=MAX_WALK;
	k2=MAX_CAR;
	Percept *percepts;
	Action *actions;
	percepts=new Percept [k1+k2];
	actions=new Action [k1+k2];
	do {
		GetPercepts(state,k1,k2);
		GenActions(state,k1,k2);
		state.Update(actions);
		Redraw();
		Sleep(ttime);
	} while (state.time<=timeout);
	delete [] percepts;
	delete [] actions;
};

Environment::GetPercept(Agent *agent,Percept *percept) {
	float dx,dy;
	float cdx,cdy,cdr;
	int w,c;
	int i,j;
	w=-1; dx=dy=1000;
	for (i=0;i<MAX_WALK;i++) 
		if (state.walkers[i]) {
			cdx=state.walkers[i]->x-agent->x;
			cdy=state.walkers[i]->y-agent->y;
			cdr=cdx*cdx+cdy*cdy;
			if ((cdr<dx*dx+dy*dy)&&(cdr>0)) {w=i; dx=cdx; dy=cdy;};
		}
	percept->WalkerDX=dx;
	percept->WalkerDY=dy;
	if (w>=0) {
		percept->WalkerAngle=state.walkers[w]->angle;
		percept->WalkerColor=state.walkers[w]->c;
	}
	c=-1; dx=dy=1000;
	for (j=0;j<MAX_CAR;j++) 
		if (state.cars[j]) {
			cdx=state.cars[j]->x-agent->x;
			cdy=state.cars[j]->y-agent->y;
			cdr=cdx*cdx+cdy*cdy;
			if ((cdr<dx*dx+dy*dy)&&(cdr>0)) {c=j; dx=cdx; dy=cdy;};
		}
	percept->CarDX=dx;
	percept->CarDY=dy;
	if (c>=0) {
		percept->CarAngle=state.cars[c]->GetAngle();
		percept->CarWidth=state.cars[c]->width;
		percept->CarLength=state.cars[c]->length;
	}
	percept->RoadLength=state.road_length;
	percept->RoadWidth=state.road_width;
}

EnvState::Update(Action *actions) {
	int i,j,k1,k2;
	k1=MAX_WALK;
	k2=MAX_CAR;
	for (i=0;i<k1;i++) if (walkers[i]) {
		walkers[i]->angle=actions[i].WantAngle;
		walkers[i]->velocity=FMax(FMin(actions[i].WantVelocity,1),-0.5);
		walkers[i]->x+=walkers[i]->velocity*cos(walkers[i]->angle);
		walkers[i]->y+=walkers[i]->velocity*sin(walkers[i]->angle);
	}
	for (j=0;j<k2;j++) if (cars[j]) {
		cars[j]->velocity=FMax(0,cars[j]->velocity-0.07);
		if (actions[j+k1].PedalBrake) cars[j]->velocity=FMax(0,cars[j]->velocity-1.6);
		if (actions[j+k1].PedalGas) cars[j]->velocity=FMin(8,cars[j]->velocity+0.5);
		cars[j]->coord+=cars[j]->velocity;
		if ((cars[j]->coord>road_length/2)&&(cars[j]->velocity<=1)) {
			cars[j]->coord=-cars[j]->coord;
			cars[j]->orient=!cars[j]->orient;
		}
		cars[j]->CalcXY(road_width);
	}
	time++;
}

Pedestrian::GenerateAction(Percept *percept,Action *action) {
	action->PedalBrake=false;
	action->PedalGas=false;
	float dx,dy,rw,cw;
	rw=percept->RoadWidth;
	cw=percept->CarWidth;
	if (percept->WalkerColor==target2) {
		dx=percept->WalkerDX;
		dy=percept->WalkerDY;
	} else
		if (target1) {
			dx=DistWithRoad(x,target1->x,rw);
			dy=DistWithRoad(y,target1->y,rw);
		} else {
			dx=0;
			dy=0;
		}
	action->WantAngle=atan2(dy,dx);
	const float pi=4*atan(1);
	action->WantVelocity=dx*dx+dy*dy;
	if (fabs(x)<5*rw/8) {
		action->WantAngle=(dx>0)?0:pi;
		if (percept->CarAngle==2-Sign(x)) {
			if (dx>0) {
				if (((x>0)&&(x<(rw-cw)/2))||(x<-(rw+cw)/2)) action->WantVelocity/=3;
			}
			if (dx<0) {
				if (((x<0)&&(x>-(rw-cw)/2))||(x>(rw+cw)/2)) action->WantVelocity/=3;
			}
		}
	}
	if (fabs(y)<5*rw/8) {
		action->WantAngle=Sign(dy)*pi/2;
		if (percept->CarAngle==1+Sign(y)) {
			if (dy>0) {
				if (((y>0)&&(y<(rw-cw)/2))||(y<-(rw+cw)/2)) action->WantVelocity/=3;
			}
			if (dx<0) {
				if (((y<0)&&(y>-(rw-cw)/2))||(y>(rw+cw)/2)) action->WantVelocity/=3;
			}
		}
	}
}

Automobile::GenerateAction(Percept *percept,Action *action) {
	float rl=percept->RoadLength;
	float rw=percept->RoadWidth;
	float wx=x+percept->WalkerDX;
	float wy=y+percept->WalkerDY;
	float cdx=percept->CarDX;
	float cdy=percept->CarDY;
	float cx=x+cdx;
	float cy=y+cdy;
	int cr=1+(percept->CarAngle)%2;
	action->PedalGas=(velocity<7);
	action->PedalBrake=(coord>=rl/2);
	switch (road) {
	case 1:
		if ((fabs(wy)<5*rw/8)&&(orient?(wy<0&&x<wx):(wy>0&&x>wx))&&fabs(x-wx)<40) {
			action->PedalGas=false;
			action->PedalBrake=true;
		}
		if ((percept->CarAngle==GetAngle())&&(orient?(x<cx):(x>cx))&&fabs(x-cx)<25) {
			action->PedalGas=false;
			action->PedalBrake=true;
		}
		if (cr!=road) {
			if (cdx*cdx+cdy*cdy<1600) {
				if (velocity>1) action->PedalGas=false;
				if (fabs(cy)<-coord) {
					action->PedalGas=false;
					action->PedalBrake=true;
				}
			}
			if (fabs(cdy)<width+percept->CarLength&&(orient?(Sign(cdx)==1):(Sign(cdx)==-1))) {
				action->PedalGas=false;
				action->PedalBrake=true;
			}
		}
		break;
	case 2:
		if ((fabs(wx)<5*rw/8)&&(orient?(wx<0&&y>wy):(wx>0&&y<wy))&&fabs(y-wy)<40) {
			action->PedalGas=false;
			action->PedalBrake=true;
		}
		if ((percept->CarAngle==GetAngle())&&(orient?(y>cy):(y<cy))&&fabs(y-cy)<25) {
			action->PedalGas=false;
			action->PedalBrake=true;
		}
		if (cr!=road) {
			if (cdx*cdx+cdy*cdy<1600) {
				if (velocity>1) action->PedalGas=false;
				if (fabs(cx)<-coord) {
					action->PedalGas=false;
					action->PedalBrake=true;
				}
			}
			if (fabs(cdx)<length+percept->CarWidth&&(orient?(Sign(cdy)==-1):(Sign(cdy)==1))) {
				action->PedalGas=false;
				action->PedalBrake=true;
			}
		}
		break;
	}
	action->WantAngle=0;
	action->WantVelocity=0;
}

Pedestrian::Pedestrian(float x,float y,float angle,Color c) {
	this->x=x;
	this->y=y;
	this->angle=angle;
	this->target1=0;
	this->target2=-1;
	this->velocity=0;
	this->c=c;
}

Automobile::Automobile(float width,float length,Color c,int road,bool orient,float coord) {
	this->width=width;
	this->length=length;
	this->road=road;
	this->coord=coord;
	this->orient=orient;
	this->velocity=0;
	this->c=c;
}

Automobile::CalcXY(float road_width) {
	int or=(orient?(-1):1);
	switch (road) {
	case 1:
		x=-or*coord;
		y=or*road_width/4;
		break;
	case 2:
		x=or*road_width/4;
		y=or*coord;
		break;
	}	
}

int Automobile::GetAngle() {
	return orient?(3*road-3):(3-road);
}

Environment::Environment(HDC dr) {
	this->drawing=dr;
	this->ttime=40;
	this->timeout=200;
	for (int i=0;i<MAX_WALK;i++) (this->state).walkers[i]=0;
	for (int j=0;j<MAX_CAR;j++) (this->state).cars[j]=0;
	this->state.terr_size=400;
	this->state.road_length=440;
	this->state.road_width=40;
	this->state.time=0;
}

Environment::Redraw() {
	HGDIOBJ hObj;
	int i,j;
	int xc,yc,c;
	float cntr=state.terr_size/2;
	SelectClipRgn(drawing,CreateRectRgn(0,0,state.terr_size,state.terr_size));
	SelectObject(drawing,CreateSolidBrush(0x008000));
	SelectObject(drawing,CreatePen(PS_SOLID,0,0));
	SaveDC(drawing);
	Rectangle(drawing,0,0,state.terr_size,state.terr_size);
	SelectObject(drawing,CreateSolidBrush(0x808080));
	SelectObject(drawing,CreatePen(PS_NULL,0,0));
	Rectangle(drawing,0,cntr-state.road_width/2,state.terr_size,cntr+state.road_width/2);
	Rectangle(drawing,cntr-state.road_width/2,0,cntr+state.road_width/2,state.terr_size);
	RestoreDC(drawing,-1);
	for (i=0;i<MAX_WALK;i++) 
		if (state.walkers[i]) {
			if (state.walkers[i]->target1) {
				xc=cntr+state.walkers[i]->target1->x;
				yc=cntr-state.walkers[i]->target1->y;
				Ellipse(drawing,xc-4,yc-4,xc+4,yc+4);
			}
		}
	SelectObject(drawing,CreatePen(PS_NULL,0,0));
	for (i=0;i<MAX_WALK;i++) 
		if (state.walkers[i]) {
			xc=cntr+state.walkers[i]->x;
			yc=cntr-state.walkers[i]->y;
			c=state.walkers[i]->c;
			SelectObject(drawing,hObj=CreateSolidBrush(c));
			Ellipse(drawing,xc-3,yc-3,xc+3,yc+3);
			DeleteObject(hObj);
			//SetPixel(drawing,xc,yc,c);
			//SetPixel(drawing,xc-1,yc,c);
			//SetPixel(drawing,xc+1,yc,c);
			//SetPixel(drawing,xc,yc-1,c);
			//SetPixel(drawing,xc,yc+1,c);
		}
	for (j=0;j<MAX_CAR;j++) 
		if (state.cars[j]) {
			xc=cntr+state.cars[j]->x;
			yc=cntr-state.cars[j]->y;
			c=state.cars[j]->c;
			SelectObject(drawing,hObj=CreateSolidBrush(c));
			switch (state.cars[j]->road) {
			case 1:	Rectangle(drawing,xc-state.cars[j]->length/2,yc-state.cars[j]->width/2,xc+state.cars[j]->length/2,yc+state.cars[j]->width/2); break;
			case 2:	Rectangle(drawing,xc-state.cars[j]->width/2,yc-state.cars[j]->length/2,xc+state.cars[j]->width/2,yc+state.cars[j]->length/2); break;
			}
			DeleteObject(hObj);
		}
	RestoreDC(drawing,-2);
}