Attribute VB_Name = "modMain"
Option Explicit

Const MMM = 1E+100
Const LLL = 0.0000001

Public A As Matrix, b As Matrix
Public C1 As Matrix, C2 As Matrix
Public XM As Matrix, YM As Matrix
Public C3 As Matrix, X3 As Matrix
Public X1 As Matrix, X2 As Matrix
Public X0 As Matrix, D As Matrix
Public VM As Matrix, WM As Matrix

Public SimplexReports(255) As Matrix, CurrentSimplexReport As Byte

Sub InitData()
    InitMatrix A, 3, 5
    InitMatrix b, 3, 1
    InitMatrix C1, 5, 1
    InitMatrix C2, 5, 1
    InitMatrix C3, 5, 1
    InitMatrix D, 5, 5
    InitMatrix XM, 5, 4
    InitMatrix YM, 4, 1
    InitMatrix VM, 3, 1
    InitMatrix WM, 3, 1
End Sub

Function LoadData(fn As String) As Boolean
    Dim s As String, i As Long
    If Len(Dir(fn)) = 0 Then LoadData = False: Exit Function
    Call InitData
    Open fn For Input Access Read As #1
        Input #1, s
        For i = 1 To 3
            Input #1, A.X(i, 1), A.X(i, 2), A.X(i, 3), A.X(i, 4), A.X(i, 5), b.X(i, 1)
        Next
        Input #1, s
        Input #1, C1.X(1, 1), C1.X(2, 1), C1.X(3, 1), C1.X(4, 1), C1.X(5, 1)
        Input #1, s
        Input #1, C2.X(1, 1), C2.X(2, 1), C2.X(3, 1), C2.X(4, 1), C2.X(5, 1)
        Input #1, s
        For i = 1 To 5
            Input #1, D.X(i, 1), D.X(i, 2), D.X(i, 3), D.X(i, 4), D.X(i, 5)
        Next
        Input #1, s
        For i = 1 To 4
            Input #1, XM.X(1, i), XM.X(2, i), XM.X(3, i), XM.X(4, i), XM.X(5, i), YM.X(i, 1)
        Next
    Close #1
    LoadData = True
End Function

Function XX(Num As Byte, X As Matrix) As Boolean
    Select Case Num
    Case 1
        XX = CopyMatrix(X1, X)
    Case 2
        XX = CopyMatrix(X2, X)
    Case 3
        XX = CopyMatrix(X3, X)
    Case Else
        XX = False
    End Select
End Function

Function FX(X As Matrix, Fun As Byte) As Double
    Dim M1 As Matrix, M2 As Matrix, MM As Matrix
    Dim sc As Boolean, F As Matrix
    sc = True
    Select Case Fun
    Case 1
        sc = sc And TransposeMatrix(C1, M1)
        sc = sc And MulMatrixes(M1, X, F)
    Case 2
        sc = sc And TransposeMatrix(C2, M1)
        sc = sc And MulMatrixes(M1, X, MM)
        sc = sc And TransposeMatrix(X, M2)
        sc = sc And DivMatr(M2, 2)
        sc = sc And MulMatrixes(M2, D, M1)
        sc = sc And MulMatrixes(M1, X, M2)
        sc = sc And AddMatrix(MM, M2, F)
    Case 3
        sc = sc And TransposeMatrix(C3, M1)
        sc = sc And MulMatrixes(M1, X, F)
    Case Else
        Exit Function
    End Select
    If F.m = 1 And F.n = 1 Then FX = F.X(1, 1)
End Function

Function TestLimits(X As Matrix) As Boolean
    Dim M1 As Matrix, M2 As Matrix, i As Long, sc As Boolean
    sc = MulMatrixes(A, X, M1)
    sc = sc And SubMatrix(b, M1, M2)
    For i = 1 To M2.m
        M2.X(i, 1) = M2.X(i, 1) + LLL
    Next
    sc = sc And IsNotNegativeMatrix(M2)
    TestLimits = sc
End Function

Function Calculation(MakeReport As Boolean, PlayModel As Boolean) As Boolean
    Dim AR As Matrix, AUp As Matrix, ADn As Matrix, BR As Matrix
    Dim XUVW As Matrix, VWXU As Matrix, gc As Double, bl As Boolean
    Dim M1 As Matrix, M2 As Matrix, M3 As Matrix, M4 As Matrix
    Dim GM As Matrix, BM As Matrix, JR As Matrix, BA As Matrix
    Dim CR As Matrix, XT As Matrix, MM As Matrix, WM As Matrix
    Dim i As Long, j As Long, k As Byte, l As Byte, v As Double
    Dim csr1 As Long, csr2 As Long, csr3 As Long, pmf As Boolean
    Dim v1 As Double, v2 As Double, v3 As Double
    Dim m As Long, n As Long, sc As Boolean
    m = A.m: n = A.n: sc = True
    CurrentSimplexReport = 0
    
    sc = sc And SimplexMax(A, b, C1, False, X1)
    csr1 = CurrentSimplexReport
    sc = sc And TestLimits(X1)
    'MsgBox FX(X1, 1)
    
    sc = sc And InitMatrix(CR, 2 * (m + n), 1) > 0
    sc = sc And InitMatrix(AUp, n, 2 * (m + n)) > 0
    sc = sc And EMatr(M1, n)
    sc = sc And TransposeMatrix(A, MM)
    sc = sc And NegMatrix(MM, M2)
    sc = sc And InitMatrix(M3, n, m) > 0
    sc = sc And LeftRightMatrix(D, M2, M4)
    sc = sc And LeftRightMatrix(M1, M3, MM)
    sc = sc And LeftRightMatrix(M4, MM, AUp)
    sc = sc And InitMatrix(ADn, m, 2 * (m + n)) > 0
    sc = sc And InitMatrix(M1, m, m + n) > 0
    sc = sc And LeftRightMatrix(A, M1, M2)
    sc = sc And EMatr(MM, m)
    sc = sc And LeftRightMatrix(M2, MM, ADn)
    sc = sc And UpDownMatrix(AUp, ADn, AR)
    sc = sc And NegMatrix(C2, M1)
    sc = sc And UpDownMatrix(M1, b, BR)
    sc = sc And SimplexMin(AR, BR, CR, True, XUVW)
    If True Then
        sc = sc And InitMatrix(VWXU, 2 * (m + n), 1)
        For i = 1 To m + n
            VWXU.X(i, 1) = XUVW.X(i + m + n, 1)
            VWXU.X(i + m + n, 1) = XUVW.X(i, 1)
        Next
        sc = sc And SimplexMin(AR, BR, VWXU, True, XUVW, False)
    End If
    csr2 = CurrentSimplexReport
    sc = sc And CopyMatrix(XUVW, X2)
    If X2.m > n Then X2.m = n
    sc = sc And TestLimits(X2)
    'MsgBox FX(X2, 2)
        
    sc = sc And TransposeMatrix(XM, XT)
    sc = sc And MulMatrixes(XM, XT, M1)
    sc = sc And RevMatrix(M1, M2)
    sc = sc And MulMatrixes(M2, XM, M3)
    sc = sc And MulMatrixes(M3, YM, C3)
    sc = sc And SimplexMin(A, b, C3, False, X3)
    csr3 = CurrentSimplexReport
    sc = sc And TestLimits(X3)
    'MsgBox FX(X3, 3)
    
    If PlayModel Then
        sc = sc And InitMatrix(GM, 3, 3) > 0
        For l = 1 To 3
            sc = sc And XX(l, M2)
            v = FX(M2, l)
            If v <> 0 Then
                For k = 1 To 3
                    sc = sc And XX(k, M1)
                    GM.X(k, l) = -Abs(1 - FX(M1, l) / v)
                Next
            Else
                sc = False
            End If
        Next
        sc = sc And InitMatrix(JR, 1, 2)
        For l = 1 To 2
            JR.X(1, l) = 1
        Next
        Do
            pmf = False: v3 = MMM
            For l = 1 To 3
                For k = 1 To 3
                    sc = sc And PartMatrix(GM, k + 0, l + 0, BM)
                    sc = sc And AdjMatrix(BM, BA)
                    sc = sc And TransposeMatrix(JR, M3)
                    sc = sc And MulMatrixes(JR, BA, M1)
                    sc = sc And MulMatrixes(M1, M3, M2)
                    If M2.m = 1 And M2.n = 1 Then
                        v = M2.X(1, 1)
                        If v <> 0 Then
                            sc = sc And DivMatrix(M1, v, MM)
                            sc = sc And TransposeMatrix(BA, M1)
                            sc = sc And MulMatrixes(JR, M1, M4)
                            sc = sc And DivMatr(M4, v)
                            If MM.X(1, 1) >= 0 And MM.X(1, 2) >= 0 And M4.X(1, 1) >= 0 And M4.X(1, 2) >= 0 Then
                                gc = Determinant(BM) / v
                                sc = sc And InitMatrix(M1, 3, 1)
                                sc = sc And InitMatrix(M2, 3, 1)
                                Select Case k
                                Case 1
                                    M1.X(2, 1) = MM.X(1, 1)
                                    M1.X(3, 1) = MM.X(1, 2)
                                Case 2
                                    M1.X(1, 1) = MM.X(1, 1)
                                    M1.X(3, 1) = MM.X(1, 2)
                                Case 3
                                    M1.X(1, 1) = MM.X(1, 1)
                                    M1.X(2, 1) = MM.X(1, 2)
                                End Select
                                Select Case l
                                Case 1
                                    M2.X(2, 1) = M4.X(1, 1)
                                    M2.X(3, 1) = M4.X(1, 2)
                                Case 2
                                    M2.X(1, 1) = M4.X(1, 1)
                                    M2.X(3, 1) = M4.X(1, 2)
                                Case 3
                                    M2.X(1, 1) = M4.X(1, 1)
                                    M2.X(2, 1) = M4.X(1, 2)
                                End Select
                                bl = True
                                For i = 1 To 3
                                    v1 = 0: v2 = 0
                                    For j = 1 To 3
                                        v1 = v1 + M1.X(j, 1) * GM.X(j, i)
                                        v2 = v2 + M2.X(j, 1) * GM.X(i, j)
                                    Next
                                    If v1 + LLL < gc Or v2 - LLL > gc Then bl = False
                                Next
                                If bl Then
                                    pmf = True
                                    If gc < v3 Then
                                        v3 = gc
                                        sc = sc And CopyMatrix(M1, VM)
                                    End If
                                End If
                            End If
                        Else
                            sc = False
                        End If
                    Else
                        sc = False
                    End If
                Next
            Next
        Loop Until True
        If pmf Then
            
        End If
    End If
    sc = sc And MulMatrix(X1, VM.X(1, 1), M1)
    sc = sc And MulMatrix(X2, VM.X(2, 1), M2)
    sc = sc And MulMatrix(X3, VM.X(3, 1), M3)
    sc = sc And CopyMatrix(M1, X0)
    sc = sc And AddMatr(X0, M2)
    sc = sc And AddMatr(X0, M3)
    
    If sc Then
        If MakeReport Then
            Open App.Path + "\report.dat" For Output Access Write As #2
                Print #2, "---------------------------------------Calculation X1---------------------------------------"
                For k = 1 To csr1
                    SaveSimplex 2, "Simplex Table" + Str(k), k, k < csr1
                Next
                Print #2, "---------------------------------------Calculation X2---------------------------------------"
                For k = csr1 + 1 To csr2
                    SaveSimplex 2, "Simplex Table" + Str(k - csr1), k, k < csr2
                Next
                Print #2, "---------------------------------------Calculation X3---------------------------------------"
                SaveVector 2, "C3", C3
                For k = csr2 + 1 To csr3
                    SaveSimplex 2, "Simplex Table" + Str(k - csr2), k, k < csr3
                Next
                Print #2, "---------------------------------------Calculation X0---------------------------------------"
                If PlayModel Then
                    Print #2, "G"
                    For k = 1 To 3
                        Print #2, RoundValue(GM.X(k, 1), 7), RoundValue(GM.X(k, 2), 7), RoundValue(GM.X(k, 3), 7)
                    Next
                    Print #2, "B"
                    For k = 1 To 2
                        Print #2, RoundValue(BM.X(k, 1), 7), RoundValue(BM.X(k, 2), 7)
                    Next
                    Print #2, "adj B"
                    For k = 1 To 2
                        Print #2, RoundValue(BA.X(k, 1), 7), RoundValue(BA.X(k, 2), 7)
                    Next
                End If
                SaveVector 2, "V", VM
            Close #2
        End If
    End If
    Calculation = sc
End Function

Sub SaveData(fn As String)
    Open fn For Output Access Write As #3
        SaveVector 3, "X1", X1
        SaveVector 3, "X2", X2
        SaveVector 3, "X3", X3
        SaveVector 3, "X0", X0
        Print #3, "F1(X1)=" & FX(X1, 1)
        Print #3, "F2(X2)=" & FX(X2, 2)
        Print #3, "F3(X3)=" & FX(X3, 3)
    Close #3
End Sub

Function SaveVector(fNum As Long, vName As String, vData As Matrix) As Boolean
    Dim i As Long, m As Long
    m = vData.m
    If m > 0 And vData.n = 1 Then
        Print #fNum, vName
        Print #fNum, RoundValue(vData.X(1, 1), 5),
        If m > 1 Then
            For i = 2 To m
                Print #fNum, RoundValue(vData.X(i, 1), 5),
            Next
        End If
        Print #fNum, vbNullString
        SaveVector = True
    Else
        SaveVector = False
    End If
End Function

Function SaveSimplex(fNum As Long, vName As String, tNum As Byte, Optional WithTeta As Boolean = True) As Boolean
    Dim i As Long, j As Long, m As Long, n As Long
    With SimplexReports(tNum)
        If .m > 1 And .n > 4 Then
            m = .m - 1: n = .n - 4
            Print #fNum, vName
            Print #fNum, "i", "Basis", "C", "X",
            For j = 1 To n
                Print #fNum, j,
            Next
            If WithTeta Then Print #fNum, "Teta",
            Print #fNum, vbNullString
            For i = 1 To m
                Print #fNum, i, RoundValue(.X(i, 1), 5), RoundValue(.X(i, 2), 5),
                For j = 0 To n
                    Print #fNum, RoundValue(.X(i, 4 + j), 5),
                Next
                If WithTeta Then Print #fNum, .X(i, 3),
                Print #fNum, vbNullString
            Next
            Print #fNum, "m+1", , ,
            For j = 0 To n
                Print #fNum, RoundValue(.X(.m, 4 + j), 5),
            Next
            Print #fNum, vbNullString
            SaveSimplex = True
        Else
            SaveSimplex = False
        End If
    End With
End Function

Function SimplexMin(A As Matrix, b As Matrix, C As Matrix, Equal As Boolean, XO As Matrix, Optional NewTable As Boolean = True) As Boolean     'AX<=B or AX=B, F(X) --> minimize
    Dim i As Long, j As Long, k As Long, m As Long, n As Long
    Dim b1 As Boolean, b2 As Boolean, b3 As Boolean
    Dim v As Double, v0 As Double, vv As Double
    Dim InBasis As Long, OutBasis As Long
    Dim S0 As Matrix, SM As Matrix
    Dim AA As Matrix, CC As Matrix
    m = A.m: n = A.n
    If b.m = m And b.n = 1 And C.m = n And C.n = 1 And m < n Then
        InitMatrix XO, n, 1
        InitMatrix S0, m + 1, n + m + 4
        InitMatrix SM, m + 1, n + m + 4
        InitMatrix AA, m, n + m
        For j = 1 To n
            For i = 1 To m
                AA.X(i, j) = A.X(i, j)
            Next
        Next
        For i = 1 To m
            AA.X(i, i + n) = 1
        Next
        InitMatrix CC, n + m, 1
        For i = 1 To n
            CC.X(i, 1) = C.X(i, 1)
        Next
        If Equal Then
            For i = 1 To m
                CC.X(n + i, 1) = MMM
            Next
        End If
        If Not NewTable Then CopyMatrix SimplexReports(CurrentSimplexReport), S0
        'S0: 1-basis, 2-C(basis), 3-teta, 4...-X
        For i = 1 To m
            If NewTable Then
                k = i + n
                S0.X(i, 1) = k
            Else
                k = S0.X(i, 1)
            End If
            S0.X(i, 2) = CC.X(k, 1)
            If NewTable Then
                S0.X(i, 4) = b.X(i, 1)
                For j = 1 To n + m
                    S0.X(i, j + 4) = AA.X(i, j)
                Next
            End If
        Next
        n = n + m
        v = 0
        For i = 1 To m
            v = v + S0.X(i, 2) * S0.X(i, 4)
        Next
        S0.X(m + 1, 4) = v
        Do
            b1 = True: b2 = True
            For j = 1 To n
                v = 0
                For i = 1 To m
                    v = v + S0.X(i, 2) * S0.X(i, j + 4)
                Next
                v = v - CC.X(j, 1)
                S0.X(m + 1, j + 4) = v
                If v > LLL Then
                    b1 = False
                    b3 = False
                    For i = 1 To m
                        If S0.X(i, j + 4) > 0 Then b3 = True
                    Next
                    b2 = b2 And b3
                End If
            Next
            v = 0
            For i = 1 To m
                v = v + S0.X(i, 2) * S0.X(i, 4)
            Next
            S0.X(m + 1, 4) = v
            If b1 Then Exit Do
            If b2 Then
                #If True Then
                    v0 = 1E-100: InBasis = 0
                    For j = 1 To n
                        v = S0.X(m + 1, j + 4)
                        If v > v0 Then
                            b3 = True
                            For i = 1 To m
                                If S0.X(i, 1) = j Then b3 = False
                            Next
                            If b3 Then InBasis = j: v0 = v
                        End If
                    Next
                #Else
                    Do
                        InBasis = Int(Rnd * n) + 1
                        b3 = True
                        For i = 1 To m
                            If S0.X(i, 1) = InBasis Then b3 = False
                        Next
                        If b3 Then Exit Do
                    Loop
                #End If
                v0 = 1E+100: OutBasis = 0
                For i = 1 To m
                    vv = S0.X(i, InBasis + 4)
                    If vv > 0 Then
                        v = S0.X(i, 4) / vv
                        S0.X(i, 3) = v
                        If v < v0 Then OutBasis = i: v0 = v
                    End If
                Next
                Call CSRPP
                CopyMatrix S0, SimplexReports(CurrentSimplexReport)
                v = S0.X(OutBasis, 4 + InBasis)
                For i = 1 To m
                    If i = OutBasis Then
                        SM.X(i, 1) = InBasis
                        SM.X(i, 2) = CC.X(InBasis, 1)
                        For j = 0 To n
                            SM.X(i, 4 + j) = S0.X(i, 4 + j) / v
                        Next
                    Else
                        SM.X(i, 1) = S0.X(i, 1)
                        SM.X(i, 2) = S0.X(i, 2)
                        For j = 0 To n
                            SM.X(i, 4 + j) = S0.X(i, 4 + j) - S0.X(OutBasis, 4 + j) * S0.X(i, 4 + InBasis) / v
                        Next
                    End If
                Next
                CopyMatrix SM, S0
            Else
                SimplexMin = False
                Exit Function
            End If
        Loop
        Call CSRPP
        CopyMatrix S0, SimplexReports(CurrentSimplexReport)
        For i = 1 To m
            j = S0.X(i, 1)
            If j <= n - m Then _
                XO.X(j, 1) = S0.X(i, 4)
        Next
        SimplexMin = True
    Else
        SimplexMin = False
    End If
End Function

Function SimplexMax(A As Matrix, b As Matrix, C As Matrix, Equal As Boolean, XO As Matrix, Optional NewTable As Boolean = True) As Boolean       'AX<=B or AX=B, F(X) --> maximize
    Dim CC As Matrix
    If NegMatrix(C, CC) Then
        SimplexMax = SimplexMin(A, b, CC, Equal, XO, NewTable)
    Else
        SimplexMax = False
    End If
End Function

Function RoundValue(X As Double, n As Byte)
    Dim tv As Double
    If n < 1 Or n > 7 Or X = 0 Then
        RoundValue = X
    Else
        tv = 10 ^ (n - 1 - Int(0.434294481903252 * Log(Abs(X))))
        RoundValue = Int(0.5 + X * tv) / tv
    End If
End Function

Function StrToVal(s As String) As Double
On Error GoTo err
    StrToVal = s
    Exit Function
err: StrToVal = Val(s)
End Function

Sub CSRPP()
    If CurrentSimplexReport = 255 Then
        CurrentSimplexReport = 0
    Else
        CurrentSimplexReport = CurrentSimplexReport + 1
    End If
End Sub
