Attribute VB_Name = "MatFunct"
Type Complex
    a As Double
    b As Double
End Type

Public Const MaxDouble = 1E+80
Public Const MinDouble = 1E-80
Public Const pi = 3.14159265358979

Public e_x1 As Complex, e_x2 As Complex, e_x3 As Complex, e_x4 As Complex

' 
Function Cot(X As Double)
    Cot = Cos(X) / Sin(X)        ' x != pi * n
End Function
Function Csc(X As Double)
    Csc = 1 / Sin(X)                ' x != pi * n
End Function
Function Sec(X As Double)
    Sec = 1 / Cos(X)              ' x != pi / 2 + pi * n
End Function

'    
Function CmplNil() As Complex
    CmplNil.a = 0
    CmplNil.b = 0
End Function
Function CmplArg(z As Complex) As Double
Dim an As Double
    If z.a = 0 Then an = pi / 2 + pi * (z.b < 0) Else an = Atn(z.b / z.a) + pi * (z.a < 0)
End Function
Function CmplAbs(z As Complex) As Double
    CmplAbs = Sqr(z.a * z.a + z.b * z.b)
End Function
Function CmplAdd(z1 As Complex, z2 As Complex) As Complex
    CmplAdd.a = z1.a + z2.a
    CmplAdd.b = z1.b + z2.b
End Function
Function CmplSub(z1 As Complex, z2 As Complex) As Complex
    CmplSub.a = z1.a - z2.a
    CmplSub.b = z1.b - z2.b
End Function
Function CmplMul0(z1 As Complex, z2 As Double) As Complex
    CmplMul0.a = z1.a * z2
    CmplMul0.b = z1.b * z2
End Function
Function CmplMul(z1 As Complex, z2 As Complex) As Complex
    CmplMul.a = z1.a * z2.a - z1.b * z2.b
    CmplMul.b = z1.a * z2.b + z2.a * z1.b
End Function
Function CmplDiv(z1 As Complex, z2 As Complex) As Complex
    CmplDiv.a = (z1.a * z2.a + z1.b * z2.b) / (z2.a * z2.a + z2.b * z2.b)
    CmplDiv.b = (z2.a * z1.b - z1.a * z2.b) / (z2.a * z2.a + z2.b * z2.b)
End Function
Function CmplExp(z As Complex, n As Double) As Complex
    CmplExp.a = CmplAbs(z) ^ n * Cos(n * CmplArg(z))
    CmplExp.b = CmplAbs(z) ^ n * Sin(n * CmplArg(z))
End Function

'  
Function ArcCos(X As Double)
    ArcCos = pi / 2 - Atn(X / Sqr(1 - X * X))
End Function
Function ArcCot(X As Double)
    ArcCot = pi / 2 - Atn(X)
End Function
Function ArcCsc(X As Double)
    ArcCsc = Atn(1 / Sqr(X * X - 1)) + (X < 0) * pi
End Function
Function ArcSec(X As Double)
    ArcSec = Atn(Sqr(X * X - 1)) + (X < 0) * pi
End Function
Function ArcSin(X As Double)
    ArcSin = Atn(X / Sqr(1 - X * X))
End Function

' 
Function Sinh(X As Double)
    Sinh = (Exp(X) - Exp(-X)) / 2
End Function
Function Cosh(X As Double)
    Cosh = (Exp(X) + Exp(-X)) / 2
End Function
Function Tanh(X As Double)
    Tanh = (Exp(X) - Exp(-X)) / (Exp(X) + Exp(-X))
End Function
Function Coth(X As Double)
    Coth = 1 / Tanh(X)          ' x != 0
End Function
Function Csch(X As Double)
    Csch = 1 / Sinh(X)          ' x != 0
End Function
Function Sech(X As Double)
    Sech = 1 / Cosh(X)
End Function

'  
Function ArcCosh(X As Double)
    ArcCosh = Log(X + Sqr(X * X - 1))       ' x >= 1
End Function
Function ArcSinh(X As Double)
    ArcSinh = Log(X + Sqr(X * X + 1))
End Function
Function ArcTanh(X As Double)
    ArcTanh = Log((1 + X) / (1 - X)) / 2    ' |x| < 1
End Function
Function ArcCoth(X As Double)
    ArcCoth = Log((X + 1) / (X - 1)) / 2    ' |x| > 1
End Function
Function ArcSech(X As Double)
    ArcSech = ArcCosh(1 / X)                ' 0 < x <= 1
End Function
Function ArcCsch(X As Double)
    ArcCsch = ArcSinh(1 / X)                ' x != 0
End Function

'  
Function Derivative(f As Byte, X As Double, dx As Double)
    dy = (f1(f, X + dx) - f1(f, X)) / dx
End Function
Function Integral(f As Byte, a As Double, b As Double, n As Long)
    s = (b - a) / n
    res = f1(f, a) / 2
    For i = 1 To n - 1
        res = res + f1(f, a + s * i)
    Next
    res = (res + f1(f, b) / 2) * s
    Integral = res
End Function

' 
Function Equ2(a As Double, b As Double, c As Double) As Byte   'a != 0
Dim d As Double
    If a = 0 Then
        If b = 0 Then
            If c = 0 Then Equ2 = 255 Else Equ2 = 0
        Else
            e_x1.a = -c / b
            e_x1.b = 0
            Equ2 = 1
        End If
    Else
        d = b * b - 4 * a * c
        Select Case Sgn(d)
        Case 1
            e_x1.a = (-b + Sqr(d)) / (2 * a)
            e_x2.a = (-b - Sqr(d)) / (2 * a)
            e_x1.b = 0: e_x2.b = 0
            Equ2 = 2
        Case 0
            e_x1.a = -b / (2 * a)
            e_x1.b = 0
            e_x2 = e_x1
            Equ2 = 2
        Case -1
            e_x1.a = -b / (2 * a)
            e_x2.a = e_x1.a
            e_x1.b = Sqr(-d) / (2 * a)
            e_x2.b = -e_x1.b
            Equ2 = 0
        End Select
    End If
End Function
Function Equ3(a As Double, b As Double, c As Double, d As Double) As Byte    'a != 0
Dim p As Double, q As Double, b3a As Double
Dim alf As Double, pp As Double
Dim qq As Double, aa As Complex, bb As Complex
    If a = 0 Then
        Equ3 = Equ2(b, c, d)
    Else
        p = c / a - (b * b) / (3 * a * a)
        b3a = b / (3 * a)
        q = d / a - p * b3a - b3a * b3a * b3a
        pp = p * p * p / 27
        qq = pp + q * q / 4
        If qq >= 0 Then
            aa.a = -q / 2 + Sqr(qq)
            bb.a = -q / 2 - Sqr(qq)
            aa.b = 0: bb.b = 0
            aa.a = Sgn(aa.a) * Abs(aa.a) ^ (1 / 3)
            bb.a = Sgn(bb.a) * Abs(bb.a) ^ (1 / 3)
        Else
            alf = ArcCos(-q / 2 / Sqr(-pp))
            aa.a = 2 * Sqr(-p / 3)
            aa.b = 0
        End If
        Select Case Sgn(qq)
        Case 1
            e_x1 = CmplAdd(aa, bb)
            Equ3 = 1
        Case 0
            e_x1 = CmplAdd(aa, bb)
            e_x2 = CmplMul0(e_x1, -0.5)
            e_x3 = e_x2
            Equ3 = 3
        Case -1
            e_x1 = CmplMul0(aa, Cos(alf / 3))
            e_x2 = CmplMul0(aa, -Cos((alf + pi) / 3))
            e_x2 = CmplMul0(aa, -Cos((alf - pi) / 3))
            Equ3 = 3
        End Select
        e_x1.a = e_x1.a - b / (3 * a)
        e_x2.a = e_x2.a - b / (3 * a)
        e_x3.a = e_x3.a - b / (3 * a)
    End If
End Function
Function Equation(f As Byte, a As Double, b As Double, e As Double)
Dim c As Double
    Do While (b - a) / 2 > e
        c = (a + b) / 2
        If f1(f, a) * f1(f, c) <= 0 Then b = c Else a = c
    Loop
    Equation = (a + b) / 2
End Function

'  
Function TwoLineEquations(a11 As Double, a12 As Double, a21 As Double, a22 As Double, g1 As Double, g2 As Double) As Vector
Dim dl As Double, d1 As Double, d2 As Double
    dl = a11 * a22 - a12 * a21
    d1 = g1 * a22 - g2 * a12
    d2 = g2 * a11 - g1 * a21
    If dl = 0 Then dl = MinDouble
    TwoLineEquations.X = d1 / dl
    TwoLineEquations.y = d2 / dl
End Function

'
Function Loga(a As Double, X As Double)
    Loga = Log(X) / Log(a)      ' a > 0,  x > 0
End Function
Function Lg(X As Double)
    Lg = 0.434294481903252 * Log(X)     ' x > 0
End Function
Function RoundValue(X As Double, n As Byte)
    If n < 1 Or n > 7 Or X = 0 Then
        RoundValue = X
    Else
        a = 10 ^ (n - 1 - Int(Lg(Abs(X))))
        RoundValue = Int(0.5 + X * a) / a
    End If
End Function
