//
//  IPFSAssistant.m
//
//  Created on 09.01.2018.
//  Copyright © 2018 Oleksandr Prosin. All rights reserved.
//

#import "IPFSAssistant.h"

#import <CommonCrypto/CommonDigest.h>
#include "base58.h"
#include "sha2.h"

@interface IPFSAssistant ()

@property unsigned long long dataLength;
@property (retain) NSArray* hashes;
@property (retain) NSString* averageHash;

@end

@implementation IPFSAssistant

- (id)init {
    return [self initWithData:nil];
}

- (id)initWithData:(NSData*)data {
    self = [super init];
    if (self) {
        self.dataLength = [data length];
        if (self.dataLength==0) {
            NSString* emptyHash = @"QmbFMke1KXqnYyBBWxB74N4c5SBnJMVAiMNRcGu6x1AwQH";
            self.hashes = @[emptyHash];
            self.averageHash = emptyHash;
        } else {
            const NSUInteger blockSize = 262144;
            NSUInteger blocksCount = (self.dataLength+blockSize-1)/blockSize;
            NSMutableArray* hashes = [NSMutableArray arrayWithCapacity:blocksCount];
            NSMutableArray* rawHashes = [NSMutableArray arrayWithCapacity:blocksCount];
            unsigned char prefix[1]={0x0a};
            unsigned char before[6]={0x08,0x02,0x12,0x80,0x80,0x10};    //второй байт 0x00 вместо 0x02 делает совместимым с d.tube
            unsigned char after[4]={0x18,0x80,0x80,0x10};
            unsigned char averPrefix[4]={0x12,0x2a,0x0a,0x22};
            unsigned char averBetween[10]={0x12,0x00,0x18,0x8e,0x80,0x10,0x12,0x2a,0x0a,0x22};
            unsigned char averDataPrefix[3]={0x08,0x02,0x18};
            unsigned char averDataBetween[4]={0x20,0x80,0x80,0x10};
            unsigned char hashBuffer[2+CC_SHA256_DIGEST_LENGTH]={0x12,0x20,0};
            char b58[100];
            for (int i=0; i<blocksCount; i++) {
                NSUInteger ll = (i<blocksCount-1)?blockSize:(self.dataLength-blockSize*(blocksCount-1));
                NSMutableString* result = [NSMutableString string];
                
                NSData* subdata = [data subdataWithRange:NSMakeRange(i*blockSize, ll)];
                
                NSMutableData* subdataex = [NSMutableData data];
                [subdataex appendBytes:before length:3];
                [subdataex appendData:[IPFSAssistant bytesForSize:subdata.length]];
                [subdataex appendData:subdata];
                [subdataex appendBytes:after length:1];
                [subdataex appendData:[IPFSAssistant bytesForSize:subdata.length]];
                
                NSMutableData* subdatafull = [NSMutableData data];
                [subdatafull appendBytes:prefix length:1];
                [subdatafull appendData:[IPFSAssistant bytesForSize:subdataex.length]];
                [subdatafull appendData:subdataex];
                
                CC_SHA256([subdatafull bytes], (CC_LONG)[subdatafull length], hashBuffer+2);
                
                [rawHashes addObject:[NSData dataWithBytes:hashBuffer length:CC_SHA256_DIGEST_LENGTH+2]];
                
                size_t n=100;
                __unused BOOL b = b58enc(b58, &n, hashBuffer, CC_SHA256_DIGEST_LENGTH+2);
                result = [NSMutableString stringWithUTF8String:b58];
                [hashes addObject:result];
            }
            if (blocksCount==1) {
                self.averageHash = hashes[0];
            } else {
                self.averageHash = nil;
                NSData* bytesForDataSize = [IPFSAssistant bytesForSize:self.dataLength];
                if (bytesForDataSize&&self.dataLength<=23958568) {   //размер проверенного файла
                    NSMutableData* data = [NSMutableData data];
                    [data appendBytes:averDataPrefix length:3];
                    [data appendData:bytesForDataSize];
                    for (int i=0; i<blocksCount-1; i++) {
                        [data appendBytes:averDataBetween length:4];
                    }
                    NSData* bytesForDataSize1 = [IPFSAssistant bytesForSize:self.dataLength transform:1];
                    if (bytesForDataSize1.length==3) {
                        [data appendBytes:averDataBetween length:1];
                        [data appendData:bytesForDataSize1];
                    } else {
                        [data appendData:bytesForDataSize1];
                    }
                    NSMutableData* resultdata = [NSMutableData data];
                    [resultdata appendBytes:averPrefix length:4];
                    for (int i=0; i<blocksCount; i++) {
                        [resultdata appendData:rawHashes[i]];
                        if (i<blocksCount-1) {
                            [resultdata appendBytes:averBetween length:10];
                        } else {
                            [resultdata appendBytes:averBetween length:3];
                            unsigned long long sz = self.dataLength+14; //data.length;
                            [resultdata appendData:[IPFSAssistant bytesForSize:sz transform:1]];
                            [resultdata appendBytes:prefix length:1];
                            [resultdata appendData:[IPFSAssistant bytesForSize:data.length]];
                        }
                    }
                    [resultdata appendData:data];
                    //const char resultbytes[1000];
                    //[resultdata getBytes:&resultbytes range:NSMakeRange(0, resultdata.length)];
                    CC_SHA256([resultdata bytes], (CC_LONG)[resultdata length], hashBuffer+2);
                    size_t n=100;
                    if (b58enc(b58, &n, hashBuffer, CC_SHA256_DIGEST_LENGTH+2)) {
                        self.averageHash = [NSMutableString stringWithUTF8String:b58];
                        //NSLog(@"%@", self.averageHash);
                    }
                }
            }
            self.hashes = hashes;
        }
    }
    return self;
}

- (id)initWithContentsOfFile:(NSString *)fileName {
    //TODO: optimize for large files
    return [self initWithData:[NSData dataWithContentsOfFile:fileName]];
}

- (id)initWithDictionary:(NSDictionary*)dict {
    self = [super init];
    if (self) {
        self.dataLength = [dict[@"dataLength"] unsignedLongLongValue];
        self.hashes = dict[@"hashes"];
        self.averageHash = dict[@"averageHash"];
    }
    return self;
}

- (NSDictionary*)dictionary {
    return [self dictionaryWithValuesForKeys:@[@"dataLength", @"hashes", @"averageHash"]];
}

- (NSData*)getDataFromIPFS {
    NSString* gateway = self.gateway;
    if (!gateway) gateway = @"https://ipfs.io";
    gateway = [gateway stringByAppendingPathComponent:@"ipfs"];
    //TODO: obtain data using hashes[0], hashes[1], ... when it is not accessible via averageHash
    if (!self.averageHash) return nil;
    NSString* path = [gateway stringByAppendingPathComponent:self.averageHash];
    return [NSData dataWithContentsOfURL:[NSURL URLWithString:path]];
}

- (BOOL)getDataFromIPFSAndSaveAs:(NSString*)fileName {
    //TODO: optimize for large files (maybe using hashes[0], hashes[1], ...), maybe add async version
    NSData* data = [self getDataFromIPFS];
    return [data writeToFile:fileName atomically:YES];
}

+ (NSData*)getDataFromIPFSWithHash:(NSString*)hash usingGateway:(NSString*)gateway {
    if (!gateway) gateway = @"https://ipfs.io";
    if (![hash hasPrefix:@"/"]) hash = [@"/ipfs/" stringByAppendingString:hash];
    NSString* path = [gateway stringByAppendingString:hash];
    return [NSData dataWithContentsOfURL:[NSURL URLWithString:path]];
}

+ (NSData*)bytesForSize:(unsigned long long)v {
    return [IPFSAssistant bytesForSize:v transform:0];
}
+ (NSData*)bytesForSize:(unsigned long long)v transform:(int)t {
    unsigned char bytes[5]={0,0,0,0,0};
    if (v<128) {
        bytes[0] = v;
        if (t==1) bytes[0] &= 0x0F;
        return [NSData dataWithBytes:bytes length:1];
    } else if (v<16384) {
        bytes[0] = ((v|128)&255);
        bytes[1] = (v>>7);
        if (t==1) bytes[1] &= 0x0F;
        return [NSData dataWithBytes:bytes length:2];
    } else if (v<2097152) { //2 MB
        bytes[0] = ((v|128)&255);
        bytes[1] = (((v>>7)|128)&255);
        bytes[2] = (v>>14);
        if (t==1) bytes[2] &= 0x0F;
        return [NSData dataWithBytes:bytes length:3];
    } else if (v<268435456) { //256 MB
        bytes[0] = ((v|128)&255);
        bytes[1] = (((v>>7)|128)&255);
        bytes[2] = (((v>>14)|128)&255);
        if (t==1) {
            bytes[2] &= 0x0F;
            return [NSData dataWithBytes:bytes length:3];
        }
        bytes[3] = (v>>21);
        return [NSData dataWithBytes:bytes length:4];
    } else if (v<34359738368) { //32 GB
        bytes[0] = ((v|128)&255);
        bytes[1] = (((v>>7)|128)&255);
        bytes[2] = (((v>>14)|128)&255);
        bytes[3] = (((v>>21)|128)&255);
        bytes[4] = (v>>28);
        if (t==1) bytes[4] &= 0x0F;
        return [NSData dataWithBytes:bytes length:5];
    } else {
        return nil;
    }
}

/*+ (IPFSAssistant*)postData:(NSData*)data toIPFSUsingGateway:(NSString*)gateway {
    IPFSAssistant* assistant;
    if (data.length==0) {
        assistant = [[IPFSAssistant alloc] initWithData:nil];
        return assistant;
    }
    if (!gateway) return nil;
    //TODO: POST using writable gateway
    return nil;
}*/

@end
