//
//  IPFSAssistant.h
//
//  Created on 09.01.2018.
//  Copyright © 2018 Oleksandr Prosin. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface IPFSAssistant : NSObject

- (id)initWithData:(NSData*)data;
- (id)initWithContentsOfFile:(NSString*)fileName;
- (id)initWithDictionary:(NSDictionary*)dict;

@property (readonly) unsigned long long dataLength;
@property (retain, readonly) NSArray* hashes;
@property (retain, readonly) NSString* averageHash;

- (NSDictionary*)dictionary;

@property (retain) NSString* gateway;

- (NSData*)getDataFromIPFS;
- (BOOL)getDataFromIPFSAndSaveAs:(NSString*)fileName;

// supports <hash>, /ipfs/<hash>, /ipns/<hash>
+ (NSData*)getDataFromIPFSWithHash:(NSString*)hash usingGateway:(NSString*)gateway;

+ (NSData*)bytesForSize:(unsigned long long)v;

@end
