#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <iostream.h>
#include <windows.h>

struct FORMULA {
	int oper;
	int index;
	double value;
	FORMULA *f1;
	FORMULA *f2;
	int usc;
	int res;
};

#define XEC 0xCCCCCCCC

char Operators[]=",() +-*/%^";
int Priorities[]={2,0,1,2,3,3,4,4,5,6,7};
int FunNumbers[]={ 11,12,13,14,
	111,112,113,114,115,116,117,118,119,
	121,122,123,124,125,126,127,128,129,130,
	131,132,133,134,
	141,142,143,144,145,146,147,148,
	171,172,173
};
#define FUNS (sizeof(FunNumbers)/sizeof(int))
char FunNames[FUNS][8]={ "angle","log","max","min",
	"sin","cos","tan","cosec","sec","cotan","asin","acos","atan",
	"abs","sign","sqrt","intdn","intup","round","rnd","frac","sqort","sqr",
	"ln","lg","lb","exp",
	"sinh","cosh","tanh","sech","asinh","acosh","atanh","asech",
	"sigmoid","jump","llim"
};
char FunDer[FUNS][32]={ "","","","",
	"xc cos","xc sin ~","1 xc cos 2 ^ /","xc cos ~ xc sin 2 ^ /","xc sin xc cos 2 ^ /","1 xc sin 2 ^ / ~","1 1 xc xc * - sqrt /","1 1 xc xc * - sqrt / ~","1 1 xc xc * + /",
	"xc sign","0","1 2 xc sqrt * /","0","0","0","","1","xc xc sqort /","xc 2 *",
	"1 xc /","1 xc 10 ln * /","1 xc 2 ln * /","xc exp",
	"xc cosh","xc sinh","1 xc cosh 2 ^ /","","","","","",
	"xc ~ exp xc sigmoid 2 ^ *","0","xc jump xc 1 - jump -"
};
bool FunDerB[FUNS];
FORMULA FunDerF[FUNS];

bool Initialized=false;

int InStr(const char *s,const char symbol){
	int i;
	for(i=0;i<strlen(s);i++)
		if(symbol==s[i]) return i;
	return -1;
}

__declspec (dllexport) WINAPI NewFormula (FORMULA **f,int oper,int index,double value,FORMULA *f1,FORMULA *f2) {
	*f=new FORMULA;
	(*f)->oper=oper;
	(*f)->index=index;
	(*f)->value=value;
	(*f)->usc=1;
	(*f)->f1=f1;
	(*f)->f2=f2;
}

__declspec (dllexport) bool WINAPI DeleteFormula (FORMULA *f,bool delme) {
	if (f) {
		f->usc--;
		if (f->usc<=0) {
			if (f->oper>0) {
				DeleteFormula(f->f1,true);
				if (f->oper<100&&f->f1!=f->f2) 
					DeleteFormula(f->f2,true);
			}
			f->f1=f->f2=0;
			if (delme)
				delete f;
			else {
				f->oper=0;
				f->value=0;
				f->index=-1;
			}
			return true;
		}
	}
	return false;
}

bool PolandToDendro(FORMULA *f,const int cvi,const int vli,const int *cv,const double *vl,int *cvr) {
	if (cvi<0) return false;
	f->oper=0;
	f->index=-1;
	f->value=0;
	f->f1=f->f2=0;
	*cvr=1;
	int ccvr;
	switch (cv[2*cvi]) {
	case 1: f->value=vl[cv[2*cvi+1]]; return true;
	case 2:
		switch (cv[2*cvi+1]) {
		case 0: f->value=0; return true;
		case 1: f->value=1; return true;
		case 2: f->value=3.14159265358979323846; return true;
		case 3: f->value=0.57721566490153286061; return true;
		case 4: f->value=rand()/32768.0; return true;
		default: return false;
		}
	case 3:
		f->index=cv[2*cvi+1];
		f->value=1;
		return true;
	case 4:
		int ccv=cv[2*cvi+1];
		if (ccv==-3) ccv=101;
		if (ccv<0) return false;
		f->oper=ccv;
		if (ccv<100) {
			NewFormula(&(f->f2),0,-1,0,0,0);
			if (!PolandToDendro(f->f2,cvi-*cvr,vli,cv,vl,&ccvr)) return false;
			*cvr+=ccvr;
		}
		NewFormula(&(f->f1),0,-1,0,0,0);
		if (!PolandToDendro(f->f1,cvi-*cvr,vli,cv,vl,&ccvr)) return false;
		*cvr+=ccvr;
		return true;
	}
	return false;
}

#define CVVLVIEW { \
	for (j=0;j<cvi;j++) cout << cv[2*j] << " " << cv[2*j+1] << "  "; \
	cout << endl; \
	for (j=0;j<vli;j++) cout << vl[j] << " "; \
	cout << endl; \
}
#define RETURN(I) {delete [] cv; delete [] vl; return I;}
#define PRIORITY(OP) ((OP<100)?Priorities[OP+3]:7)
__declspec (dllexport) int WINAPI CreateFormula (FORMULA *f,char *s,bool poland,int *maxx,int *errpos,int *errlen) {
	*maxx=-1; *errpos=0; *errlen=0;
	if (!*s) return 1;
	int *cv=new int [4*strlen(s)];
	double *vl=new double [strlen(s)];
	char cs,ts;
	int cvi=0,vli=0,i,j,k=0,ii,jj,kk;
	srand(GetTickCount()*GetTickCount()*rand());
	//
	while (strlen(s)) {
		cs=(s[0]>='A'&&s[0]<='Z')?(s[0]+'a'-'A'):s[0];
		if (cs==' ') {
			s++; k++;
		} else if (cs==':') {
			cv[2*cvi]=4; cv[2*cvi+1]=4;
			cvi++; s++; k++;
		} else if (cs=='~') {
			cv[2*cvi]=4; cv[2*cvi+1]=102;
			cvi++; s++; k++;
		} else {
			i=InStr(Operators,cs);
			if (i>=0) {
				cv[2*cvi]=4; cv[2*cvi+1]=i-3;
				if (!poland)
					if ((i==4||i==5)&&(cvi?(cv[2*cvi-2]==4&&cv[2*cvi-1]!=-1):true))
						cv[2*cvi+1]+=100;
				cvi++; s++; k++;
			} else {
				j=1;
				if (cs=='x') {
					int ind=0;
					while ((j<strlen(s))?((s[j]>='0'&&s[j]<='9')||s[j]=='c'):false) j++;
					if (j>7) {
						*errpos=k;
						*errlen=j;
						RETURN(4);
					} else {
						cv[2*cvi]=3;
						if (j>1) {
							if (j==2&&s[1]=='c')
								ind=XEC;
							else {
								ts=s[j];
								s[j]=0;
								ind=atoi(s+1);
								s[j]=ts;
							}
						}
						cv[2*cvi+1]=ind;
						if (*maxx<ind) *maxx=ind;
						cvi++; s+=j; k+=j;
					}
				} else if (cs>='0'&&cs<='9') {
					while ((j<strlen(s))?((s[j]>='0'&&s[j]<='9')||(s[j]=='e')||(s[j]=='.')||(s[j-1]=='e'&&(s[j]=='+'||s[j]=='-'))):false) j++;
					ts=s[j]; s[j]=0;
					double d=strtod(s,0);
					s[j]=ts; s+=j; k+=j;
					if (d==0||d==1) {
						cv[2*cvi]=2; cv[2*cvi+1]=(int)d;
					} else {
						cv[2*cvi]=1; cv[2*cvi+1]=vli; vl[vli++]=d;
					}
					cvi++;
				} else if (cs>='a'&&cs<='z') {
					while ((j<strlen(s))?((s[j]>='A'&&s[j]<='Z')||(s[j]>='a'&&s[j]<='z')):false) j++;
					if (j==1) {*errpos=k; *errlen=j; return 3;}
					if (j==2&&cs=='p'&&(s[1]=='i'||s[1]=='I')) {
						cv[2*cvi]=2; cv[2*cvi+1]=2; cvi++; s+=j; k+=j;
					} else if (j==2&&cs=='e'&&(s[1]=='m'||s[1]=='M')) {
						cv[2*cvi]=2; cv[2*cvi+1]=3; cvi++; s+=j; k+=j;
					} else if (j==2&&cs=='r'&&(s[1]=='d'||s[1]=='D')) {
						cv[2*cvi]=2; cv[2*cvi+1]=4; cvi++; s+=j; k+=j;
					} else {
						ts=s[j]; s[j]=0; kk=-1;
						for (ii=0;ii<FUNS;ii++) {
							jj=FunNumbers[ii];
							if (cs==FunNames[ii][0]&&!strcmp(s+1,FunNames[ii]+1)) {
								kk=jj; goto m1;
							}
						}
m1:						s[j]=ts;
						if (kk==-1) {
							*errpos=k; *errlen=j; RETURN((j<3)?2:3);
						} else {
							s+=j; k+=j;
							cv[2*cvi]=4; cv[2*cvi+1]=kk; cvi++;
						}
					}
				} else {
					*errpos=k;
					*errlen=1;
					RETURN(1);
				}
			}
		}
	}
	if (cvi<=0) RETURN(5);
	//CVVLVIEW;
	//   
	if (!poland) {
		int *stck=new int [cvi],stc=0;
		int ouc=0,dpr,cv2i1;
		for (i=0;i<cvi;i++) {
			if (cv[2*i]==4) {
				cv2i1=cv[2*i+1];
m2:				if (cv2i1==-1) {
					if (!stc) {delete [] stck; RETURN(6);}
					while (stck[--stc]!=-2) {
						cv[2*ouc]=4;
						cv[2*ouc+1]=stck[stc];
						ouc++;
						if (!stc) {delete [] stck; RETURN(6);}
					}
				} else {
					if (stc&&cv2i1!=-2) {
						dpr=PRIORITY(cv2i1)-PRIORITY(stck[stc-1]);
						if (dpr<0||(!dpr&&cv2i1<100)) {
							cv[2*ouc]=4;
							if (stck[--stc]==-2) {delete [] stck; RETURN(7);}
							cv[2*ouc+1]=stck[stc];
							ouc++;
							goto m2;
						}
					}
					stck[stc++]=cv2i1;
				}
			} else {
				cv[2*ouc]=cv[2*i];
				cv[2*ouc+1]=cv[2*i+1];
				ouc++;
			}
		}
		for (i=stc-1;i>=0;i--) {
			cv[2*ouc]=4;
			if (stck[i]==-2) {delete [] stck; RETURN(7);}
			cv[2*ouc+1]=stck[i];
			ouc++;
		}
		cvi=ouc;
		delete [] stck;
	}
	//CVVLVIEW;
	//   
	int ccvr;
	if (!PolandToDendro(f,cvi-1,vli,cv,vl,&ccvr)||ccvr!=cvi) {
		*errpos=0;
		*errlen=0;
		RETURN(5);
	}
	delete [] cv;
	delete [] vl;
	return 0;
}

__declspec (dllexport) double WINAPI CalcFormula(FORMULA *f,const int n,const double *d) {
	if (!f) return 0;
	if (f->oper<=0) {
		if (f->index<0)
			return f->value;
		else
			if (f->index<n)
				return f->value*d[f->index];
			else
				return 0;
	}
	double a=CalcFormula(f->f1,n,d),b=a;
	if (f->oper<100&&f->f1!=f->f2) b=CalcFormula(f->f2,n,d);
	switch (f->oper) {
	case 1: return a+b;
	case 2: return a-b;
	case 3: return a*b;
	case 4: return a/b;
	case 5: return fmod(a,b);
	case 6: return pow(a,b);
	case 11: return atan2(b,a);
	case 12: return log(b)/log(a);
	case 13: return a>b?a:b;
	case 14: return a<b?a:b;
	case 101: return +a;
	case 102: return -a;
	case 111: return sin(a);
	case 112: return cos(a);
	case 113: return tan(a);
	case 114: return 1/sin(a);
	case 115: return 1/cos(a);
	case 116: return cos(a)/sin(a);
	case 117: return asin(a);
	case 118: return acos(a);
	case 119: return atan(a);
	case 121: return fabs(a);
	case 122: return (a==0)?0:(a/fabs(a));
	case 123: return sqrt(a);
	case 124: return floor(a);
	case 125: return ceil(a);
	case 126: return floor(a+0.5);
	case 127: return a*(rand()+rand())/65536.0;
	case 128: return a-floor(a);
	case 129: return sqrt(a*a+1);
	case 130: return a*a;
	case 131: return log(a);
	case 132: return log10(a);
	case 133: return 1.4426950408889634074*log(a);
	case 134: return exp(a);
	case 141: return sinh(a);
	case 142: return cosh(a);
	case 143: return tanh(a);
	case 144: return 1/cosh(a);
	case 145: return log(a+sqrt(a*a+1));
	case 146: return log(a+sqrt(a*a-1));
	case 147: return log((1+a)/(1-a))/2;
	case 148: return log((1+sqrt(1-a*a))/a);
	case 171: return 1/(1+exp(-a));
	case 172: return a>=0;
	case 173: return (a>=1)?1:((a>0)*a);
	default: return 0;
	}
}

__declspec (dllexport) int WINAPI HalfCalcFormula (FORMULA *f,const int n,const double *d,const bool *b) {
	if (!f) return 0;
	if (f->oper<=0) {
		int ind=f->index;
		if (ind>=n||ind<0) return 0;
		if (b[ind]) {
			f->value*=d[ind];
			f->index=-1;
			return 1;
		}
		return 0;
	}
	int hcf=HalfCalcFormula(f->f1,n,d,b);
	if (f->oper<100) {
		if (f->f1==f->f2)
			hcf+=hcf;
		else
			hcf+=HalfCalcFormula(f->f2,n,d,b);
	}
	return hcf;
}

__declspec (dllexport) WINAPI ViewFormula (FORMULA *f,char *s) {
	int tp; char sf[32];
	if (f) {
		if (f->oper) {
			if (f->oper==101||f->oper==102) tp=1;
				else if (f->oper<=10) tp=2;
				else if (f->oper>=110) tp=3;
				else tp=4;
			bool b=rand()<5000;
			switch (tp) {
			case 1: if (b) strcat(s,"{"); else strcat(s,"["); break;
			case 2: if (b) strcat(s,"{"); else strcat(s,"("); break;
			}
			if (tp==1) {
				s[strlen(s)+1]=0;
				s[strlen(s)]=Operators[f->oper+3-100];
			}
			if (tp==3||tp==4) {
				for (int i=0;i<FUNS;i++)
					if (FunNumbers[i]==f->oper) strcat(s,FunNames[i]);
			}
			if (tp==3&&(!f->f1->oper||f->f1->oper>=110)) strcat(s,"(");
			if (tp==4) strcat(s,"(");
			ViewFormula(f->f1,s);
			if (tp==3&&(!f->f1->oper||f->f1->oper>=110)) strcat(s,")");
			if (tp==2) {
				strcpy(sf," ");
				sf[0]=Operators[f->oper+3];
				strcat(s,sf);
			}
			if (tp==4) strcat(s,",");
			if (!(tp%2)) ViewFormula(f->f2,s);
			if (tp==4) strcat(s,")");
			switch (tp) {
			case 1: if (b) strcat(s,"}"); else strcat(s,"]"); break;
			case 2: if (b) strcat(s,"}"); else strcat(s,")"); break;
			}
		} else {
			if (fabs(f->value)!=1||f->index<0) {
				if (f->value==(int)(f->value))
					itoa((int)f->value,sf,10);
				else
					sprintf(sf,"%f",f->value);
				strcat(s,sf);
			}
			if (f->value==-1&&f->index>=0) strcat(s,"-");
			if (f->index>=0) {
				strcat(s,"x");
				if (f->index) {
					itoa(f->index,sf,10);
					strcat(s,sf);
				}
			}
		}
	}
}

__declspec (dllexport) int WINAPI TestFormula (FORMULA *f,int *maxx,int *depth) {
	*maxx=-1; *depth=0;
	if (!f) return 10;
	int o=f->oper,ret=0,mx,dp,dp2;
	if (o>=1000) return 11;
	if (o>=110) {
		bool b=false;
		for (int i=0;i<FUNS;i++)
			if (FunNumbers[i]==f->oper) b=true;
		if (!b) return 11;
	}
	if (o) {
		ret=TestFormula(f->f1,&mx,&dp);
		if (mx>*maxx) *maxx=mx;
		if (ret) {*depth+=dp; return ret;}
		if (o<100) {
			ret=TestFormula(f->f2,&mx,&dp2);
			if (mx>*maxx) *maxx=mx;
			if (ret) {*depth+=(dp>dp2)?dp:dp2; return ret;}
			if ((o==4||o==5)&&!f->f2->oper&&f->f2->value==0) return 1;
			if (o==6&&!f->f2->oper&&f->f2->value==0&&!f->f1->oper&&f->f1->value==0) return 2;
			if (o==11&&!f->f2->oper&&f->f2->value==0&&!f->f1->oper&&f->f1->value==0) return 3;
		} else {
			*depth+=dp;
			if ((o>130&&o<=133)&&!f->f1->oper&&f->f1->value==0) return 3;
		}
	} else {
		*maxx=f->index;
		*depth=1;
	}
	return 0;
}

#define ONEBRANCH(F) \
	if (ecmem) { \
		dst->F=src->F; \
		dst->F->usc++; \
	} else { \
		dst->F=new FORMULA; \
		CopyFormula(src->F,dst->F,false); \
	}
__declspec (dllexport) bool WINAPI CopyFormula (FORMULA *src,FORMULA *dst,bool ecmem) {
	if (src&&dst) {
		dst->oper=src->oper;
		dst->value=src->value;
		dst->index=src->index;
		dst->usc=src->usc;
		if (src->oper>0) {
			ONEBRANCH(f1);
			if (src->oper<100) ONEBRANCH(f2);
		}
		return true;
	} else return false;
}

__declspec (dllexport) bool WINAPI EqualFormulas (FORMULA *f1,FORMULA *f2) {
	if (!f1&&!f2) return true;
	if (f1==f2) return true;
	if (f1&&f2) {
		int op=f1->oper;
		if (op!=f2->oper) return false;
		if (!op) return (f1->value==f2->value&&f1->index==f2->index);
		bool b=EqualFormulas(f1->f1,f2->f1);
		if (op<100) b=b&&EqualFormulas(f1->f2,f2->f2);
		return b;
	}
	return false;
}

bool SFCalc (FORMULA *f) {
	if (!f) return false;
	if (f->oper<=0) return false;
	if (f->oper<100) {
		if (!f->f1->oper&&f->f1->index<0&&!f->f2->oper&&f->f2->index<0) {
			f->value=CalcFormula(f,0,0);
			f->oper=0;
			f->index=-1;
			DeleteFormula(f->f1,true);
			DeleteFormula(f->f2,true);
			f->f1=f->f2=0;
			return true;
		} else return SFCalc(f->f1)||SFCalc(f->f2);
	} else {
		if (!f->f1->oper&&f->f1->index<0) {
			f->value=CalcFormula(f,0,0);
			f->oper=0;
			f->index=-1;
			DeleteFormula(f->f1,true);
			f->f1=f->f2=0;
			return true;
		} else return SFCalc(f->f1);
	}
}

#define SETVALUE(V) {DeleteFormula(f->f1,true); DeleteFormula(f->f2,true); f->oper=0; f->value=V; f->index=-1; return true;}
bool SFClean (FORMULA *f) {
	if (!f) return false;
	if (f->oper<=0) return false;
	bool b=false;
	if (f->oper<100) {
		bool z1=(!f->f1->oper&&f->f1->value==0);
		bool z2=(!f->f2->oper&&f->f2->value==0);
		bool o1=(!f->f1->oper&&f->f1->value==1&&f->f1->index<0);
		bool o2=(!f->f2->oper&&f->f2->value==1&&f->f2->index<0);
		switch (f->oper) {
		case 2:
			if (EqualFormulas(f->f1,f->f2)) SETVALUE(0);
		case 1:
			if (z2) {f->oper=101; DeleteFormula(f->f2,true); return true;}
			if (z1) {f->oper+=100; f->f1=f->f2; return true;}
			if (EqualFormulas(f->f1,f->f2)) {f->oper=3; NewFormula(&(f->f2),0,-1,2,0,0); return true;}
			break;
		case 4:
			if (EqualFormulas(f->f1,f->f2)) SETVALUE(1);
		case 3:
			if (o2) {f->oper=101; DeleteFormula(f->f2,true); return true;}
			if (o1&&f->oper==3) {f->oper=101; f->f1=f->f2; return true;}
			if (EqualFormulas(f->f1,f->f2)) {f->oper=6; NewFormula(&(f->f2),0,-1,2,0,0); return true;}
		case 5:
			if (o2&&f->oper==5) SETVALUE(0);
			if (z1||(z2&&f->oper==3)) SETVALUE(0);
			break;
		}
		b=SFClean(f->f2);
	}
	return b||SFClean(f->f1);
}

bool SFStruct (FORMULA *f) {
	if (!f) return false;
	if (f->oper<=0) return false;
	if (f->oper==101) {
		f->index=f->f1->index;
		f->oper=f->f1->oper;
		f->value=f->f1->value;
		f->f2=f->f1->f2;
		f->f1=f->f1->f1;
		return true;
	}
	bool b=false;
	if (f->oper<100) {
		if (EqualFormulas(f->f1,f->f2)&&f->f1!=f->f2) {
			DeleteFormula(f->f2,true);
			f->f2=f->f1; f->f2->usc++;
			return true;
		}
		b=SFStruct(f->f2);
	}
	return b||SFStruct(f->f1);
}

bool SFIntel (FORMULA *f) {
	if (!f) return false;
	if (f->oper<=0) return false;
	switch (f->oper) {
	case 1:
	case 2:
		if (!f->f1->oper&&!f->f2->oper&&f->f1->index==f->f2->index) {
			f->index=f->f1->index;
			f->value=f->f1->value+((f->oper==1)?1:-1)*f->f2->value;
			f->oper=0;
			f->f1=f->f2=0;
			return true;
		}
		break;
	case 3:
	case 4:
		if (!f->f1->oper&&!f->f2->oper) {
			if (f->f1->index==f->f2->index&&f->oper==4) {
				f->f1->index=f->f2->index=-1;
				return true;
			}
			if (f->f2->index==-1) {
				if (f->oper==3)
					f->f1->value*=f->f2->value;
				else
					f->f1->value/=f->f2->value;
				f->oper=101;
				DeleteFormula(f->f2,true);
				return true;
			}
			if (f->f1->index==-1&&f->oper==3) {
				f->index=f->f2->index;
				f->value=f->f1->value*f->f2->value;
				f->oper=0;
				DeleteFormula(f->f1,true);
				DeleteFormula(f->f2,true);
				return true;
			}
		}
		break;
	case 12:
		if (!f->f1->oper&&f->f1->value==10&&f->f1->index==-1) {
			f->f1=f->f2;
			f->oper=132;
			return true;
		}
		break;
	case 13:
	case 14:
		if (EqualFormulas(f->f1,f->f2)) {
			f->oper=101; return true;
		}
		break;
	case 102:
		if (!f->f1->oper) {
			f->oper=0;
			f->value=-f->f1->value;
			f->index=f->f1->index;
			DeleteFormula(f->f1,true);
			f->f1=0;
			return true;
		}
		break;
	}
	bool b=SFIntel(f->f1);
	if (f->oper<100) b=b||SFIntel(f->f2);
	return b;
}

__declspec (dllexport) int WINAPI SimplifyFormula (FORMULA *f,const int n) {
	if (n<=0) return 0;
	int i=0;
	while ((SFCalc(f)||SFClean(f)||SFStruct(f)||SFIntel(f))&&i<n) i++;
	return i;
}

InitFM () {
	int i,j;
	for (i=0;i<FUNS;i++)
		FunDerB[i]=!CreateFormula(&FunDerF[i],FunDer[i],true,&j,&j,&j);
	Initialized=true;
}

bool ChangeXC (FORMULA *f,FORMULA *xc) {
	if (!f) return true;
	if (!f->oper)
		if (f->index==XEC) return CopyFormula(xc,f,true); else return true;
	else {
		if (!ChangeXC(f->f1,xc)) return false;
		if (f->oper<100)
			if (!ChangeXC(f->f2,xc)) return false;
		return true;
	}
}

__declspec (dllexport) bool WINAPI DerivativeOfFormula(FORMULA *f,const int indx,FORMULA *fD) {
	if (!f||indx<0) return false;
	if (!Initialized) InitFM();
	if (f->oper<110) {
		switch (f->oper) {
		case 0:
			fD->oper=0;
			fD->index=-1;
			fD->f1=fD->f2=0;
			if (f->index==indx) fD->value=f->value; else fD->value=0;
			return true;
		case 1:
		case 2:
			fD->oper=f->oper;
			fD->f1=new FORMULA;
			if (DerivativeOfFormula(f->f1,indx,fD->f1)) {
				fD->f2=new FORMULA;
				return DerivativeOfFormula(f->f2,indx,fD->f2);
			} else return false;
		case 101:
		case 102:
			fD->oper=f->oper;
			fD->f1=new FORMULA;
			return DerivativeOfFormula(f->f1,indx,fD->f1);
		case 3:
			if (!f->f1->oper&&f->f1->index!=indx) {
				fD->oper=3;
				fD->f1=new FORMULA;
				fD->f1->oper=0;
				fD->f1->index=f->f1->index;
				fD->f1->value=f->f1->value;
				fD->f2=new FORMULA;
				return DerivativeOfFormula(f->f2,indx,fD->f2);
			} else {
				fD->oper=1;
				fD->f1=new FORMULA;
				fD->f1->oper=3;
				fD->f1->f1=new FORMULA;
				if (!DerivativeOfFormula(f->f1,indx,fD->f1->f1)) return false;
				fD->f1->f2=new FORMULA;
				if (!CopyFormula(f->f2,fD->f1->f2,false)) return false;
				fD->f2=new FORMULA;
				fD->f2->oper=3;
				fD->f2->f2=new FORMULA;
				if (!DerivativeOfFormula(f->f2,indx,fD->f2->f2)) return false;
				fD->f2->f1=new FORMULA;
				if (!CopyFormula(f->f1,fD->f2->f1,false)) return false;
				return true;
			}
		case 4:
			if (!f->f2->oper&&f->f2->index!=indx) {
				fD->oper=4;
				fD->f2=new FORMULA;
				fD->f2->oper=0;
				fD->f2->index=f->f2->index;
				fD->f2->value=f->f2->value;
				fD->f1=new FORMULA;
				return DerivativeOfFormula(f->f1,indx,fD->f1);
			} else {
				fD->oper=4;
				fD->f1=new FORMULA;
				fD->f1->oper=2;
				fD->f1->f1=new FORMULA;
				fD->f1->f1->oper=3;
				fD->f1->f1->f1=new FORMULA;
				if (!DerivativeOfFormula(f->f1,indx,fD->f1->f1->f1)) return false;
				fD->f1->f1->f2=new FORMULA;
				if (!CopyFormula(f->f2,fD->f1->f1->f2,false)) return false;
				fD->f1->f2=new FORMULA;
				fD->f1->f2->oper=3;
				fD->f1->f2->f2=new FORMULA;
				if (!DerivativeOfFormula(f->f2,indx,fD->f1->f2->f2)) return false;
				fD->f1->f2->f1=new FORMULA;
				if (!CopyFormula(f->f1,fD->f1->f2->f1,false)) return false;
				fD->f2=new FORMULA;
				fD->f2->oper=3;
				fD->f2->f1=new FORMULA;
				if (!CopyFormula(f->f2,fD->f2->f1,false)) return false;
				fD->f2->f2=fD->f2->f1;
				return true;
			}
		case 5:
			fD->oper=2;
			fD->f1=new FORMULA;
			if (!DerivativeOfFormula(f->f1,indx,fD->f1)) return false;
			NewFormula(&(fD->f2),3,-1,0,new FORMULA,0);
			if (!DerivativeOfFormula(f->f2,indx,fD->f2->f1)) return false;
			NewFormula(&(fD->f2->f2),124,-1,0,new FORMULA,0);
			if (!CopyFormula(f,fD->f2->f2->f1,false)) return false;
			fD->f2->f2->f1->oper=4;
			return true;
		case 6:
			fD->oper=3;
			fD->f1=new FORMULA;
			if (!CopyFormula(f,fD->f1,false)) return false;
			NewFormula(&(fD->f2),1,-1,0,new FORMULA,new FORMULA);
			fD->f2->f1->oper=fD->f2->f2->oper=3;
			fD->f2->f1->f1=new FORMULA;
			if (!DerivativeOfFormula(f->f2,indx,fD->f2->f1->f1)) return false;
			NewFormula(&(fD->f2->f1->f2),131,-1,0,new FORMULA,0);
			if (!CopyFormula(f->f1,fD->f2->f1->f2->f1,false)) return false;
			fD->f2->f2->f1=new FORMULA;
			if (!CopyFormula(f->f2,fD->f2->f2->f1,false)) return false;
			NewFormula(&(fD->f2->f2->f2),4,-1,0,new FORMULA,new FORMULA);
			if (!DerivativeOfFormula(f->f1,indx,fD->f2->f2->f2->f1)) return false;
			if (!CopyFormula(f->f1,fD->f2->f2->f2->f2,false)) return false;
			return true;
		default: return false;
		}
	} else {
		int FunInd;
		for (int i=0;i<FUNS;i++) {
			if (FunNumbers[i]==f->oper) FunInd=i;
		}
		if (!FunDerB[FunInd]) return false;
		fD->oper=3;
		fD->f1=new FORMULA;
		if (!CopyFormula(&FunDerF[FunInd],fD->f1,false)) return false;
		if (!ChangeXC(fD->f1,f->f1)) return false;
		fD->f2=new FORMULA;
		if (!DerivativeOfFormula(f->f1,indx,fD->f2)) return false;
		return true;
	}
}

__declspec (dllexport) bool WINAPI IntegralOfFormula(FORMULA *f,const int indx,FORMULA *fD) {
	if (!f||indx<0) return false;
	switch (f->oper) {
		case 0:
			if (f->index==indx) {

			} else {
				
			}
			return true;
		case 1:
		case 2:
		case 101:
		case 102:
		default: return false;
	}
}

__declspec (dllexport) double WINAPI ValueDerivative (FORMULA *f,int n,double *d,int indx,double ldx,double rdx) {
	if (ldx<0) ldx=0;
	if (rdx<0) rdx=0;
	if (ldx==0&&rdx==0) rdx=ldx=CalcFormula(f,n,d)*1e-8;
	if (indx>=n||indx<0) return 0;
	double dd=d[indx],d1,d2;
	d[indx]=dd+rdx;
	d1=CalcFormula(f,n,d);
	d[indx]=dd-ldx;
	d2=CalcFormula(f,n,d);
	d[indx]=dd;
	return (d1-d2)/(ldx+rdx);
}

__declspec (dllexport) double WINAPI ValueIntegral (FORMULA *f,int n,double *d,int indx,double a,double b,int prec) {
	if (prec<=0) prec=10000;
    double s=(b-a)/prec;
	double dd=d[indx];
	d[indx]=b;
    double res=CalcFormula(f,n,d)/2;
	d[indx]=a;
    res+=CalcFormula(f,n,d)/2;
    for (int i=1;i<prec;i++) {
		d[indx]+=s;
		res+=CalcFormula(f,n,d);
	}
    res*=s;
	d[indx]=dd;
	return res;
}
