(deffacts unknown_mb
	(mb.model unknown)
	(mb.chipset unknown)
	(mb.cpusocket unknown)
	(mb.cpucount unknown)
	(mb.haveintvga unknown)
	(mb.haveintsb unknown)
)

(deffacts unknown_cpu
	(cpu.manufactor unknown)
	(cpu.model unknown)
	(cpu.socket unknown)
	(cpu.maxtech unknown)		;16bit,32bit,MMX,SIMD,64bit
	(cpu.threads unknown)
	(cpu.cache unknown)		;max level
	(cpu.corefreq unknown)		;in MHz
	(cpu.FSB unknown)		;in MBps
)

(deffacts unknown_hdd
	(hdd.manufactor unknown)
	(hdd.model unknown)
	(hdd.interface unknown)		;IDE,SATA,SCSI
	(hdd.space unknown)		;in GB
	(hdd.maxspeed unknown)		;in MBps
	(hdd.accesstime unknown)	;in ms
)

(deffacts unknown_diff
	(additional_CPU_connector unknown)	;e.g., Slot1->Socket370
	(FPU unknown)				;both internal or external
	(CPUs unknown)				;SP or MP
	(RAM unknown)				;in MB
	(ext_DC unknown)			;external disk controller
	(ext_SB unknown)			;external sound-blaster
	(ext_VGA unknown)			;external video-adapter
)

(defclass MBEXTSLOTS (is-a USER)(role concrete)
	(slot ISA (type INTEGER)(default -1)(storage local))
	(slot AGP (type INTEGER)(default -1)(storage local))
	(slot PCI (type INTEGER)(default -1)(storage local))
	(slot PCIE (type INTEGER)(default -1)(storage local))
	(slot PCIEG (type INTEGER)(default -1)(storage local))
	(slot VESA (type INTEGER)(default -1)(storage local))
)

(defclass MBMEMSLOTS (is-a USER)(role concrete)
	(slot SIMM (type INTEGER)(default -1)(storage local))
	(slot SDR_DIMM (type INTEGER)(default -1)(storage local))
	(slot DDR_DIMM (type INTEGER)(default -1)(storage local))
	(slot DDR2_DIMM (type INTEGER)(default -1)(storage local))
	(slot RIMM (type INTEGER)(default -1)(storage local))
)

(defclass EXTCARD (is-a USER)(role concrete)
	(slot card_slot (type SYMBOL)(storage local)(default unknown)(visibility public))
	(slot chip_manufactor (type SYMBOL)(storage local)(default unknown)(visibility public))
	(slot chip_model (type SYMBOL)(storage local)(default unknown)(visibility public))
	(slot chip_count (type INTEGER)(storage local)(default -1)(visibility public))
)

(defclass VGA (is-a EXTCARD)(role concrete)
	(slot support2D
		(type SYMBOL)
		(allowed-symbols yes no unknown)
		(default unknown)
		(storage local)
	)
	(slot support3D
		(type SYMBOL)
		(allowed-symbols yes no unknown)
		(default unknown)
		(storage local)
	)
	(slot memory (type FLOAT)(storage local))			;MB
	(slot fillrate (type FLOAT)(storage local))			;Mpps
	(slot ramdac_freq (type FLOAT)(storage local))			;MHz
	(slot vga_count (type INTEGER)(default -1)(storage local))
	(slot dvi_count (type INTEGER)(default -1)(storage local))
)

(defclass DISKCONTROLLER (is-a EXTCARD)(role concrete)
	(slot interface (type SYMBOL)(default unknown)(storage local))
	(slot maxspeed (type FLOAT)(storage local))			;MBps
	(slot raid0
		(type SYMBOL)
		(allowed-symbols yes no unknown)
		(default unknown)
		(storage local)
	)
	(slot raid1
		(type SYMBOL)
		(allowed-symbols yes no unknown)
		(default unknown)
		(storage local)
	)
	(slot raid5
		(type SYMBOL)
		(allowed-symbols yes no unknown)
		(default unknown)
		(storage local)
	)
)

(defclass SOUNDBLASTER (is-a EXTCARD)(role concrete)
	(slot support3D
		(type SYMBOL)
		(allowed-symbols yes no unknown)
		(default unknown)
		(storage local)
	)
	(slot out_channels (type INTEGER)(default -1)(storage local))
	(slot midi_count (type INTEGER)(default -1)(storage local))
)

(definstances MB.internal
	(MB.extslots.all of MBEXTSLOTS)
	(MB.extslots.free of MBEXTSLOTS)
	(MB.memslots.all of MBMEMSLOTS)
	(MB.memslots.free of MBMEMSLOTS)
	(MB.intvga of VGA)
	(MB.intsb of SOUNDBLASTER)
	(MB.intdc of DISKCONTROLLER)
)

(definstances extcards
	(external_vga of VGA)
	(external_sb of SOUNDBLASTER)
	(external_dc of DISKCONTROLLER)
)

(deffunction printcard (?exc)
	(bind ?chips (send ?exc get-chip_count))
	(printout t " - chip: "
		(send ?exc get-chip_manufactor) " "
		(send ?exc get-chip_model)
	)
	(if (> ?chips 1) then (printout t " (" ?chips " chips)"))
	(printout t crlf)
	(printout t " - card slot: " (send ?exc get-card_slot) crlf)	
)	

(deffunction printvga (?vga)
	;(printcard ?vga)
	(printout t " - memory: " (send ?vga get-memory) " MB" crlf)
	(if (eq (send ?vga get-support2D) yes) then
		(printout t " - support 2D-modes" crlf)
	)
	(bind ?fr (send ?vga get-fillrate))
	(if (> ?fr 0) then
		(printout t " - support 3D-modes" crlf)
		(printout t " - fillrate: " ?fr " Mpix/s" crlf) 
	)
	(bind ?fr (send ?vga get-ramdac_freq))
	(if (> ?fr 0) then
		(printout t " - RAMDAC: " ?fr " MHz" crlf)
	)
	(bind ?pc (send ?vga get-vga_count))
	(if (>= ?pc 0) then (printout t " - VGA ports: " ?pc crlf))
	(bind ?pc (send ?vga get-dvi_count))
	(if (>= ?pc 0) then (printout t " - DVI ports: " ?pc crlf))
)

(deffunction printsb (?sb)
	;(printcard ?sb)
	(printout t " - output channels: " (send ?sb get-out_channels) crlf)
	(if (eq (send ?sb get-support3D) yes) then
		(printout t " - support hardware 3D" crlf)
	)
	(bind ?pc (send ?sb get-midi_count))
	(if (>= ?pc 0) then (printout t " - MIDI ports: " ?pc crlf))
)

(deffunction printdc (?dc)
	;(printcard ?dc)
	(printout t " - interface: " (send ?dc get-interface) crlf)
	(printout t " - speed: " (send ?dc get-maxspeed) " MB/s" crlf)
	(bind ?r0 (send ?dc get-raid0))
	(bind ?r1 (send ?dc get-raid1))
	(bind ?r5 (send ?dc get-raid5))
	(if (eq ?r0 yes) then (printout t " - support RAID0" crlf))
	(if (eq ?r1 yes) then (printout t " - support RAID1" crlf))
	(if (eq ?r5 yes) then (printout t " - support RAID5" crlf))
)

(deffunction inputdc (?dc)
	(if (eq (send ?dc get-interface) unknown) then
		(printout t " - interface (IDE, SATA, SCSI): ")
		(send ?dc put-interface (read))
	)
	(if (<= (send ?dc get-maxspeed) 0) then
		(printout t " - interface speed, MB/s: ")
		(send ?dc put-maxspeed (read))
	)
	(if (eq (send ?dc get-raid0) unknown) then
		(printout t " - RAID0 (yes/no)? ")
		(send ?dc put-raid0 (read))
	)
	(if (eq (send ?dc get-raid1) unknown) then
		(printout t " - RAID1 (yes/no)? ")
		(send ?dc put-raid1 (read))
	)
	(if (eq (send ?dc get-raid5) unknown) then
		(printout t " - RAID5 (yes/no)? ")
		(send ?dc put-raid5 (read))
	)
)

(deffunction inputsb (?sb)
	(if (< (send ?sb get-out_channels) 0) then
		(printout t " - output channels: ")
		(send ?sb put-out_channels (read))
	)
	(if (eq (send ?sb get-support3D) unknown) then
		(printout t " - 3D-acceleration (yes/no)? ")
		(send ?sb put-support3D (read))
	)
	(if (< (send ?sb get-midi_count) 0) then
		(printout t " - Number of MIDI ports: ")
		(send ?sb put-midi_count (read))
	)
)

(deffunction inputvga (?vga)
	(if (eq (send ?vga get-chip_manufactor) Matrox) then (send ?vga put-support2D yes))
	(if (eq (send ?vga get-chip_manufactor) 3Dfx) then (send ?vga put-support3D yes))
	(bind ?dfr 0)
	(if (eq (send ?vga get-chip_model) VSA-100) then
		(send ?vga put-support2D yes)
		(send ?vga put-ramdac_freq 350)
		(bind ?dfr (* 166 (send ?vga get-chip_count)))
	)
	(if (<= (send ?vga get-memory) 0) then
		(printout t " - video memory, MB: ")
		(send ?vga put-memory (read))
	)
	(if (eq (send ?vga get-support3D) no) then (send ?vga put-support2D yes))
	(if (eq (send ?vga get-support2D) unknown) then
		(printout t " - support 2D-modes (yes/no)? ")
		(send ?vga put-support2D (read))
	)
	(if (eq (send ?vga get-support2D) no) then (send ?vga put-support3D yes))
	(if (eq (send ?vga get-support3D) unknown) then
		(printout t " - support 3D-modes (yes/no)? ")
		(send ?vga put-support3D (read))
	)
	(if (eq (send ?vga get-support3D) yes) then
		(if (<= (send ?vga get-fillrate) 0) then
			(if (eq ?dfr 0) then
				(printout t " - fillrate in 3D-modes, Mpix/s: ")
			else
				(printout t " - fillrate in 3D-modes (~" ?dfr "), Mpix/s: ")
			)
			(send ?vga put-fillrate (read))
		)
	)
	(if (<= (send ?vga get-ramdac_freq) 0) then
		(printout t " - RAMDAC frequency, MHz: ")
		(send ?vga put-ramdac_freq (read))
	)
	(if (< (send ?vga get-vga_count) 0) then
		(printout t " - number of VGA ports: ")
		(send ?vga put-vga_count (read))
	)
	(if (< (send ?vga get-dvi_count) 0) then
		(printout t " - Number of DVI ports: ")
		(send ?vga put-dvi_count (read))
	)
)

(deffunction inputcard (?exc)
	(if (eq (send ?exc get-chip_model) unknown) then
		(printout t " - chip model: ")
		(send ?exc put-chip_model (read))
	)
	(bind ?cm (send ?exc get-chip_model))
	(if (or (eq ?cm i960) (eq ?cm i80303)) then (send ?exc put-chip_manufactor Intel))
	(if (or
		(eq ?cm VSA-100)
		(eq ?cm Voodoo)
		(eq ?cm Voodoo1)
		(eq ?cm Voodoo2)
		(eq ?cm Voodoo3)
		(eq ?cm VoodooI)
		(eq ?cm VoodooII)
		(eq ?cm VoodooIII)
		(eq ?cm VoodooRush)
	) then
		(send ?exc put-chip_manufactor 3Dfx)
	)
	(if (or
		(eq ?cm Mystique)
		(eq ?cm G200)
		(eq ?cm G400)
		(eq ?cm G450)
		(eq ?cm G550)
		(eq ?cm Parhelia)
	) then
		(send ?exc put-chip_manufactor Matrox)
	)
	(if (or
		(eq ?cm Rage)
		(eq ?cm RageXL)
		(eq ?cm Radeon)
		(eq ?cm RadeonVE)
		(eq ?cm RadeonLE)
		(eq ?cm Radeon7000)
		(eq ?cm Radeon7500)
		(eq ?cm Radeon8500)
		(eq ?cm Radeon9100)
		(eq ?cm Radeon9200)
		(eq ?cm Radeon9600)
		(eq ?cm Radeon9700)
		(eq ?cm Radeon9800)
		(eq ?cm RadeonX300)
		(eq ?cm RadeonX600)
		(eq ?cm RadeonX700)
		(eq ?cm RadeonX800)
	) then
		(send ?exc put-chip_manufactor ATI)
	)
	(if (or
		(eq ?cm RivaTNT)
		(eq ?cm RivaTNT2)
		(eq ?cm GeForce)
		(eq ?cm GeForce256)
		(eq ?cm GeForce2)
		(eq ?cm GeForce2MX)
		(eq ?cm GeForce2GTS)
		(eq ?cm GeForce2Ti)
		(eq ?cm GeForce3)
		(eq ?cm GeForce3Ti)
		(eq ?cm GeForce4)
		(eq ?cm GeForce4MX)
		(eq ?cm GeForce4Ti)
		(eq ?cm GeForceFX)
		(eq ?cm GeForce6600)
		(eq ?cm GeForce6800)
		(eq ?cm FX5200)
		(eq ?cm FX5600)
		(eq ?cm FX5700)
		(eq ?cm FX5800)
		(eq ?cm FX5900)
		(eq ?cm NV40)
		(eq ?cm NV43)
	) then
		(send ?exc put-chip_manufactor nVidia)
	)
	(if (eq (send ?exc get-chip_manufactor) unknown) then
		(printout t " - chip manufactor: ")
		(send ?exc put-chip_manufactor (read))
	)
	(if (<= (send ?exc get-chip_count) 0) then
		(printout t " - number of chips (1 - standard): ")
		(send ?exc put-chip_count (read))
	)
	(if (eq (send ?exc get-card_slot) unknown) then
		(printout t " - card slot (AGP, ISA, VESA, PCI, PCIE, PCIEG): ")
		(send ?exc put-card_slot (read))
	)
)

(deffunction t40 ()
	(printout t t t t t t t t t t t t t t t t t t t t)
	(printout t t t t t t t t t t t t t t t t t t t t)
)	

(defrule entry_point
	?init <- (initial-fact)
=>
	(t40)
	(send [MB.intvga] put-support2D yes)
	(assert (mb.haveintdc yes))
	(assert (knownmbslots no))
	(assert (advice finish))
	(assert (action_print))
	(assert (action 0))
	(retract ?init)
)

(defrule input_mb_model
	(action 0)
	?unk <- (mb.model unknown)
=>
	(printout t "Enter motherboard model (e.g., PB850): ")
	(assert (mb.model (read)))
	(retract ?unk)
)

(defrule gen_mb_chipset_SIS5598
	(action 0)
	?unk <- (mb.chipset unknown)
	(mb.model PB850)
=>
	(assert (mb.chipset SIS5598))
	(retract ?unk)
)

(defrule gen_mb_socket_7
	(action 0)
	?unk <- (mb.cpusocket unknown)
	(mb.chipset SIS5598)
=>
	(assert (mb.cpusocket Socket7))
	(retract ?unk)
)

(defrule gen_mb_onecpu
	(action 0)
	?unk <- (mb.cpucount unknown)
	(or
		(mb.chipset SIS5598)
		(mb.chipset i845)
		(mb.chipset i850)
	)
=>
	(assert (mb.cpucount 1))
	(retract ?unk)
)

(defrule gen_mb_slots_PB850
	(action 0)
	(mb.model PB850)
	?f <- (knownmbslots no)
=>
	(send [MB.extslots.all] put-ISA 2)
	(send [MB.extslots.all] put-AGP 0)
	(send [MB.extslots.all] put-PCI 3)
	(send [MB.extslots.all] put-PCIE 0)
	(send [MB.extslots.all] put-PCIEG 0)
	(send [MB.extslots.all] put-VESA 0)
	(send [MB.memslots.all] put-SIMM 4)
	(send [MB.memslots.all] put-SDR_DIMM 0)
	(send [MB.memslots.all] put-DDR_DIMM 0)
	(send [MB.memslots.all] put-DDR2_DIMM 0)
	(send [MB.memslots.all] put-RIMM 0)
	(assert (knownmbslots yes))
	(retract ?f)
)

(defrule gen_mb_slots_i850
	(action 0)
	(mb.chipset i850)
=>
	(send [MB.memslots.all] put-SIMM 0)
	(send [MB.memslots.all] put-SDR_DIMM 0)
	(send [MB.memslots.all] put-DDR_DIMM 0)
	(send [MB.memslots.all] put-DDR2_DIMM 0)
	(send [MB.extslots.all] put-VESA 0)
)

(defrule gen_mb_slots_i845
	(action 0)
	(mb.chipset i845)
=>
	(send [MB.memslots.all] put-SIMM 0)
	(send [MB.memslots.all] put-RIMM 0)
	(send [MB.memslots.all] put-DDR2_DIMM 0)
	(send [MB.extslots.all] put-VESA 0)
)

(defrule gen_mb_intvga_SIS5598
	(action 0)
	?unk <- (mb.haveintvga unknown)
	(mb.chipset SIS5598)
=>
	(assert (mb.haveintvga yes))
	(send [MB.intvga] put-chip_manufactor SIS)
	(send [MB.intvga] put-chip_model 5598)
	(send [MB.intvga] put-chip_count 1)
	(send [MB.intvga] put-support3D no)
	(send [MB.intvga] put-memory 4)
	(send [MB.intvga] put-fillrate 0)
	(send [MB.intvga] put-vga_count 1)
	(send [MB.intvga] put-dvi_count 0)
	(retract ?unk)
)

(defrule gen_mb_nointvga
	(action 0)
	?unk <- (mb.haveintvga unknown)
	(mb.chipset i850)
=>
	(assert (mb.haveintvga no))
	(retract ?unk)
)

(defrule gen_mb_intsb_ESS1869
	(action 0)
	?unk <- (mb.haveintsb unknown)
	(mb.model PB850)
=>
	(assert (mb.haveintsb yes))
	(send [MB.intsb] put-chip_manufactor ESS)
	(send [MB.intsb] put-chip_model 1869)
	(send [MB.intsb] put-chip_count 1)
	(send [MB.intsb] put-support3D no)
	(send [MB.intsb] put-out_channels 2)
	(send [MB.intsb] put-midi_count 1)
	(retract ?unk)
)

(defrule gen_mb_intdc_PIO4
	(action 0)
	(mb.model PB850)
	?f <- (mb.haveintdc ?hidc)
	(test (neq ?hidc yes!))
=>
	(send [MB.intdc] put-chip_count 1)
	(send [MB.intdc] put-interface IDE)
	(send [MB.intdc] put-maxspeed 2)
	(send [MB.intdc] put-raid0 no)
	(send [MB.intdc] put-raid1 no)
	(send [MB.intdc] put-raid5 no)
	(assert (mb.haveintdc yes!))
	(retract ?f)
)

(defrule input_mb_chipset
	(action 0)
	?unk <- (mb.chipset unknown)
=>
	(printout t "Enter motherboard chipset: ")
	(assert (mb.chipset (read)))
	(retract ?unk)
)

(defrule input_mb_cpusocket
	(action 0)
	?unk <- (mb.cpusocket unknown)
=>
	(printout t "Enter socket type (e.g., SocketA) for CPU: ")
	(assert (mb.cpusocket (read)))
	(retract ?unk)
)

(defrule input_mb_cpucount
	(action 0)
	?unk <- (mb.cpucount unknown)
=>
	(printout t "Enter socket count for CPU: ")
	(assert (mb.cpucount (read)))
	(retract ?unk)
)

(defrule input_mb_dc
	(action 0)
	?f <- (mb.haveintdc yes)
=>
	(printout t "Integrated disk controller:" crlf)
	(inputdc [MB.intdc])
	(assert (mb.haveintdc yes!))
	(retract ?f)
)

(defrule input_mb_hisb
	(action 0)
	?unk <- (mb.haveintsb unknown)
=>
	(printout t "Do you have integrated sound-blaster (yes/no)? ")
	(bind ?hisb (lowcase (read)))
	(if (or (eq ?hisb yes) (eq ?hisb y)) then
		(assert (mb.haveintsb yes))
	else
		(assert (mb.haveintsb no))
	)
	(retract ?unk)
)

(defrule input_mb_sb
	(action 0)
	?f <- (mb.haveintsb yes)
=>
	(inputsb [MB.intsb])
	(assert (mb.haveintsb yes!))
	(retract ?f)
)

(defrule input_mb_hivga
	(action 0)
	?unk <- (mb.haveintvga unknown)
=>
	(printout t "Do you have integrated video-adapter (yes/no)? ")
	(bind ?hivga (lowcase (read)))
	(if (or (eq ?hivga yes) (eq ?hivga y)) then
		(assert (mb.haveintvga yes))
	else
		(assert (mb.haveintvga no))
	)
	(retract ?unk)
)

(defrule input_mb_vga
	(action 0)
	?f <- (mb.haveintvga yes)
=>
	(inputvga [MB.intvga])
	(assert (mb.haveintvga yes!))
	(retract ?f)
)

(defrule input_mb_slots
	(action 0)
	?f <- (knownmbslots no)
=>
	(printout t "Enter number of slots for cards:" crlf)
	(if (< (send [MB.extslots.all] get-PCI) 0) then
		(printout t " - PCI: ")
		(send [MB.extslots.all] put-PCI (read))
	)
	(if (< (send [MB.extslots.all] get-PCIE) 0) then
		(printout t " - PCI-X (small): ")
		(send [MB.extslots.all] put-PCIE (read))
	)
	(if (< (send [MB.extslots.all] get-PCIEG) 0) then
		(printout t " - PCI-X (large): ")
		(send [MB.extslots.all] put-PCIEG (read))
	)
	(if (< (send [MB.extslots.all] get-ISA) 0) then
		(printout t " - ISA: ")
		(send [MB.extslots.all] put-ISA (read))
	)
	(if (< (send [MB.extslots.all] get-AGP) 0) then
		(printout t " - AGP: ")
		(send [MB.extslots.all] put-AGP (read))
	)
	(if (< (send [MB.extslots.all] get-VESA) 0) then
		(printout t " - VESA: ")
		(send [MB.extslots.all] put-VESA (read))
	)
	(printout t "Enter number of slots for memory:" crlf)
	(if (< (send [MB.memslots.all] get-SIMM) 0) then
		(printout t " - SIMM: ")
		(send [MB.memslots.all] put-SIMM (read))
	)
	(if (< (send [MB.memslots.all] get-SDR_DIMM) 0) then
		(printout t " - SDR DIMM: ")
		(send [MB.memslots.all] put-SDR_DIMM (read))
	)
	(if (< (send [MB.memslots.all] get-DDR_DIMM) 0) then
		(printout t " - DDR DIMM: ")
		(send [MB.memslots.all] put-DDR_DIMM (read))
	)
	(if (< (send [MB.memslots.all] get-DDR2_DIMM) 0) then
		(printout t " - DDR2 DIMM: ")
		(send [MB.memslots.all] put-DDR2_DIMM (read))
	)
	(if (< (send [MB.memslots.all] get-RIMM) 0) then
		(printout t " - RIMM: ")
		(send [MB.memslots.all] put-RIMM (read))
	)
	(assert (knownmbslots yes))
	(retract ?f)
)

(defrule input_cpu_model
	(action 0)
	?unk <- (cpu.model unknown)
=>
	(printout t "Enter CPU model (e.g., C3): ")
	(assert (cpu.model (read)))
	(retract ?unk)
;	(bind ?*cpu.model* (read))
;	(bind ?cpu.manufactor "AMD")
;	(format t "%s %s%n" ?cpu.manufactor ?cpu.model)
)

(defrule input_aCPUc
	(action 0)
	?unk <- (additional_CPU_connector unknown)
=>
	(printout t "Do you use additional CPU connector (yes/no)? ")
	(bind ?aCPUc (lowcase (read)))
	(if (or (eq ?aCPUc yes) (eq ?aCPUc y)) then
		(assert (additional_CPU_connector yes))
	else
		(assert (additional_CPU_connector no))
	)
	(retract ?unk)
)

(defrule gen_cpu_manufactor_Intel
	(action 0)
	?unk <- (cpu.manufactor unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model Pentium))
		(test (eq ?model Pentium1))
		(test (eq ?model PentiumMMX))
		(test (eq ?model PentiumPro))
		(test (eq ?model Pentium2))
		(test (eq ?model PentiumII))
		(test (eq ?model Pentium3))
		(test (eq ?model PentiumIII))
		(test (eq ?model Pentium4))
		(test (eq ?model PentiumIV))
		(test (eq ?model Pentium4HT))
		(test (eq ?model Pentium4EE))
		(test (eq ?model Pentium4XE))
		(test (eq ?model Celeron))
		(test (eq ?model Xeon))
		(test (eq ?model i8086))
		(test (eq ?model i80186))
		(test (eq ?model i80286))
		(test (eq ?model i80386))
		(test (eq ?model i80486))
	)
=>
	(assert (cpu.manufactor Intel))
	(retract ?unk)
)

(defrule gen_cpu_manufactor_AMD
	(action 0)
	?unk <- (cpu.manufactor unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model 5k86))
		(test (eq ?model K5))
		(test (eq ?model K6))
		(test (eq ?model K6-2))
		(test (eq ?model K6-2+))
		(test (eq ?model K6-3))
		(test (eq ?model K7))
		(test (eq ?model K8))
		(test (eq ?model Duron))
		(test (eq ?model Athlon))
		(test (eq ?model AthlonXP))
		(test (eq ?model Athlon64))
		(test (eq ?model AthlonFX))
		(test (eq ?model Opteron))
		(test (eq ?model Sempron))
	)
=>
	(assert (cpu.manufactor AMD))
	(retract ?unk)
)

(defrule gen_cpu_manufactor_VIA
	(action 0)
	?unk <- (cpu.manufactor unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model Cyrix3))
		(test (eq ?model C3))
	)
=>
	(assert (cpu.manufactor VIA))
	(retract ?unk)
)

(defrule gen_cpu_manufactor_IDT
	(action 0)
	?unk <- (cpu.manufactor unknown)
	(cpu.model WinChip)
=>
	(assert (cpu.manufactor IDT))
	(retract ?unk)
)

(defrule gen_cpu_socket
	(action 0)
	?unk <- (cpu.socket unknown)
	(mb.cpusocket ?mbcs)
	(test (neq ?mbcs unknown))
	(additional_CPU_connector no)
=>
	(assert (cpu.socket ?mbcs))
	(retract ?unk)
)

(defrule gen_cpu_socket_Slot1
	(action 0)
	?unk <- (cpu.socket unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model PentiumII))
		(test (eq ?model Pentium2))
	)
=>
	(assert (cpu.socket Slot1))
	(retract ?unk)
)

(defrule gen_cpu_socket_SocketA
	(action 0)
	?unk <- (cpu.socket unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model Duron))
		(test (eq ?model AthlonXP))
	)
=>
	(assert (cpu.socket SocketA))
	(retract ?unk)
)

(defrule gen_cpu_socket_Socket7
	(action 0)
	?unk <- (cpu.socket unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model PentiumMMX))
		(test (eq ?model CyrixMII))
		(test (eq ?model CyrixM2))
	)
=>
	(assert (cpu.socket Socket7))
	(retract ?unk)
)

(defrule gen_cpu_tech_16bit
	(action 0)
	?unk <- (cpu.maxtech unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model i80186))
		(test (eq ?model i80286))
	)
=>
	(assert (cpu.maxtech 16bit))
	(retract ?unk)
)

(defrule gen_cpu_tech_32bit
	(action 0)
	?unk <- (cpu.maxtech unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model K5))
		(test (eq ?model PentiumPro))
		(test (eq ?model i80386))
		(test (eq ?model i80486))
		(test (eq ?model 5k86))
	)
=>
	(assert (cpu.maxtech 32bit))
	(retract ?unk)
)

(defrule gen_cpu_tech_MMX
	(action 0)
	?unk <- (cpu.maxtech unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model K6))
		(test (eq ?model CyrixMII))
		(test (eq ?model CyrixM2))
		(test (eq ?model PentiumMMX))
		(test (eq ?model Pentium2))
		(test (eq ?model PentuimII))
	)
=>
	(assert (cpu.maxtech MMX))
	(retract ?unk)
)

(defrule gen_cpu_tech_SIMD
	(action 0)
	?unk <- (cpu.maxtech unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model PentiumIII))
		(test (eq ?model PentiumIV))
		(test (eq ?model Pentium3))
		(test (eq ?model Pentium4))
		(test (eq ?model K6-2))
		(test (eq ?model K6-2+))
		(test (eq ?model K6-3))
		(test (eq ?model K7))
		(test (eq ?model K8))
		(test (eq ?model Duron))
		(test (eq ?model Athlon))
		(test (eq ?model AthlonXP))
		(test (eq ?model Cyrix3))
		(test (eq ?model C3))
	)
=>
	(assert (cpu.maxtech SIMD))
	(retract ?unk)
)

(defrule gen_cpu_tech_64bit
	(action 0)
	?unk <- (cpu.maxtech unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model K8))
		(test (eq ?model Athlon64))
		(test (eq ?model AthlonFX))
		(test (eq ?model Opteron))
	)
=>
	(assert (cpu.maxtech 64bit))
	(retract ?unk)
)

(defrule gen_cpu_cache_2
	(action 0)
	?unk <- (cpu.cache unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model K6))
		(test (eq ?model K6-2))
		(test (eq ?model Duron))
		(test (eq ?model Athlon))
		(test (eq ?model AthlonXP))
		(test (eq ?model CyrixMII))
		(test (eq ?model CyrixM2))
		(test (eq ?model PentiumMMX))
		(test (eq ?model Pentium2))
		(test (eq ?model PentiumII))
		(test (eq ?model Pentium3))
		(test (eq ?model PentiumIII))
	)
=>
	(assert (cpu.cache 2))
	(retract ?unk)
)

(defrule gen_cpu_cache_3
	(action 0)
	?unk <- (cpu.cache unknown)
	(cpu.model ?model)
	(or
		(test (eq ?model Pentium4EE))
		(test (eq ?model Pentium4XE))
		(test (eq ?model K6-2+))
		(test (eq ?model K6-3))
	)
=>
	(assert (cpu.cache 3))
	(retract ?unk)
)

(defrule gen_single_cpu
	(action 0)
	?unk <- (CPUs unknown)
	(mb.cpucount 1)
=>
	(assert (CPUs 1))
	(retract ?unk)
)

(defrule gen_fpu_yes
	(action 0)
	?unk <- (FPU unknown)
	(or
		(cpu.maxtech MMX)
		(cpu.maxtech SIMD)
		(cpu.maxtech 64bit)
		(cpu.model Celeron)
		(cpu.model Pentium)
		(cpu.model Pentium1)
		(cpu.model Pentium4)
		(cpu.model PentiumIV)
		(cpu.model K5)
		(cpu.model 5k86)
		(cpu.socket Socket7)
	)
=>
	(assert (FPU yes))
	(retract ?unk)
)

(defrule gen_cpu_single_thread
	(action 0)
	?unk <- (cpu.threads unknown)
	(or
		(cpu.maxtech 16bit)
		(cpu.maxtech 32bit)
		(cpu.socket Socket370)
		(cpu.socket Socket7)
		(cpu.socket Slot1)
		(cpu.socket SlotA)
		(cpu.model Duron)
		(cpu.model AthlonXP)
	)
=>
	(assert (cpu.threads 1))
	(retract ?unk)
)

(defrule gen_cpu_multi_thread
	(action 0)
	?unk <- (cpu.threads unknown)
	(cpu.model Pentium4HT)
=>
	(assert (cpu.threads 2))
	(retract ?unk)
)

(defrule input_cpu_manufactor
	(action 0)
	?unk <- (cpu.manufactor unknown)
=>
	(printout t "Enter CPU manufactor (e.g., Intel): ")
	(assert (cpu.manufactor (read)))
	(retract ?unk)
)

(defrule input_cpu_socket
	(action 0)
	?unk <- (cpu.socket unknown)
	(additional_CPU_connector yes)
=>
;	(printout t "Do you use 
	(printout t "Enter CPU socket (e.g., LGA775): ")
	(bind ?readcpus (read))
	(assert (cpu.socket ?readcpus))
	(retract ?unk)
)

(defrule input_cpu_tech
	(action 0)
	?unk <- (cpu.maxtech unknown)
=>
	(printout t "Enter CPU max. technology (16bit, 32bit, MMX, SIMD, 64bit): ")
	(assert (cpu.maxtech (read)))
	(retract ?unk)
)

(defrule input_cpu_threads
	(action 0)
	?unk <- (cpu.threads unknown)
=>
	(printout t "Enter CPU threads count (1 - standard; 2 - HT; ...): ")
	(assert (cpu.threads (read)))
	(retract ?unk)
)

(defrule input_cpu_cachelevels
	(action 0)
	?unk <- (cpu.cache unknown)
=>
	(printout t "Enter CPU cache levels count (including on motherboard): ")
	(assert (cpu.cache (read)))
	(retract ?unk)
)

(defrule input_cpu_corefreq
	(action 0)
	?unk <- (cpu.corefreq unknown)
=>
	(printout t "Enter CPU real core frequency, MHz: ")
	(assert (cpu.corefreq (read)))
	(retract ?unk)
)

(defrule input_cpu_FSB
	(action 0)
	?unk <- (cpu.FSB unknown)
=>
	(printout t "Enter CPU real FSB, MHz: ")
	(assert (cpu.FSB (* 8 (read))))
	(retract ?unk)
)

(defrule input_CPUs
	(action 0)
	?unk <- (CPUs unknown)
=>
	(printout t "Enter CPU count (1 - standard; 2 - dual; ...): ")
	(assert (CPUs (read)))
	(retract ?unk)
)

(defrule input_FPU
	(action 0)
	?unk <- (FPU unknown)
=>
	(printout t "Do you use FPU (yes/no)? ")
	(bind ?exFPU (lowcase (read)))
	(if (or (eq ?exFPU yes) (eq ?exFPU y)) then
		(assert (FPU yes))
	else
		(assert (FPU no))
	)
	(retract ?unk)
)

(defrule input_RAM
	(action 0)
	?unk <- (RAM unknown)
=>
	(printout t "Enter summary RAM, MB: ")
	(assert (RAM (read)))
	(retract ?unk)
)

(defrule input_hdd_model
	(action 0)
	?unk <- (hdd.model unknown)
=>
	(printout t "Enter HDD (best) model: ")
	(assert (hdd.model (read)))
	(retract ?unk)
)

(defrule gen_hdd_manufactor_Seagate
	(action 0)
	?unk <- (hdd.manufactor unknown)
	(or
		(hdd.model Barracuda)
		(hdd.model Cheetah)
		(hdd.model ST340014A)
		(hdd.model ST380011A)
		(hdd.model ST336607LW)
		(hdd.model ST336607LC)
		(hdd.model ST373307LW)
	)
=>
	(assert (hdd.manufactor Seagate))
	(retract ?unk)
)

(defrule gen_hdd_manufactor_WD
	(action 0)
	?unk <- (hdd.manufactor unknown)
	(or
		(hdd.model Raptor)
		(hdd.model Caviar)
		(hdd.model WD400BB)
		(hdd.model WD400JB)
	)
=>
	(assert (hdd.manufactor WD))
	(retract ?unk)
)

(defrule gen_hdd_manufactor_Samsung
	(action 0)
	?unk <- (hdd.manufactor unknown)
	(or
		(hdd.model SpinPoint)
		(hdd.model SV0431D)
		(hdd.model SV0411N)
		(hdd.model SP0411N)
		(hdd.model SP1614C)
	)
=>
	(assert (hdd.manufactor Samsung))
	(retract ?unk)
)

(defrule gen_hdd_space_40
	(action 0)
	?unk <- (hdd.space unknown)
	(or
		(hdd.model SV0411N)
		(hdd.model SP0411N)
		(hdd.model ST340014A)
		(hdd.model WD400BB)
		(hdd.model WD400JB)
	)
=>
	(assert (hdd.space 40))
	(retract ?unk)
)

(defrule gen_hdd_interface_IDE
	(action 0)
	?unk <- (hdd.interface unknown)
	(or
		(hdd.model SV0411N)
		(hdd.model SP0411N)
		(hdd.model ST340014A)
		(hdd.model ST380011A)
		(hdd.model WD400BB)
		(hdd.model WD400JB)
	)
=>
	(assert (hdd.interface IDE))
	(retract ?unk)
)

(defrule gen_hdd_interface_SCSI
	(action 0)
	?unk <- (hdd.interface unknown)
	(or
		(hdd.model Cheetah)
		(hdd.model ST336607LW)
		(hdd.model ST336607LC)
		(hdd.model ST373307LW)
	)
=>
	(assert (hdd.interface SCSI))
	(retract ?unk)
)

(defrule gen_hdd_ast85
	(action 0)
	?unk <- (hdd.accesstime unknown)
	(or
		(hdd.model ST340014A)
		(hdd.model ST380011A)
	)
=>
	(assert (hdd.accesstime 8.5))
	(retract ?unk)
)

(defrule input_hdd_manufactor
	(action 0)
	?unk <- (hdd.manufactor unknown)
=>
	(printout t "Enter HDD manufactor: ")
	(assert (hdd.manufactor (read)))
	(retract ?unk)
)

(defrule input_hdd_space
	(action 0)
	?unk <- (hdd.space unknown)
=>
	(printout t "Enter HDD space, GB: ")
	(assert (hdd.space (read)))
	(retract ?unk)
)

(defrule input_hdd_interface
	(action 0)
	?unk <- (hdd.interface unknown)
=>
	(printout t "Enter HDD interface (IDE, SATA, SCSI): ")
	(assert (hdd.interface (read)))
	(retract ?unk)
)

(defrule input_hdd_maxspeed
	(action 0)
	?unk <- (hdd.maxspeed unknown)
	(hdd.interface ?interface)
=>
;	(if (eq ?interface IDE)
;		then (printout t "Enter HDD max speed (~2-133), MB/s: ")
;	else
;		(if (eq ?interface SATA)
;			then (printout t "Enter HDD max speed (~50-150), MB/s: ")
;			else
;				(if (eq ?interface SCSI)
;					then (printout t "Enter HDD max speed (~10-640), MB/s: ")
;					else (printout t "Enter HDD max speed, MB/s: ")
;				)
;		)
;	)
	(printout t "Enter HDD max linear speed, MB/s: ")
	(assert (hdd.maxspeed (read)))
	(retract ?unk)
)

(defrule input_hdd_accesstime
	(action 0)
	?unk <- (hdd.accesstime unknown)
=>
	(printout t "Enter HDD average seek time, ms: ")
	(assert (hdd.accesstime (read)))
	(retract ?unk)
)

(defrule input_external_dc
	(action 0)
	?f <- (ext_DC unknown)
=>
	(printout t "Do you have external disk controller (yes/no)? ")
	(bind ?ext (lowcase (read)))
	(if (or (eq ?ext yes) (eq ?ext y)) then
		(assert (ext_DC yes))
		(inputcard [external_dc])
		(inputdc [external_dc])
	else
		(assert (ext_DC no))
	)
	(retract ?f)
)

(defrule input_external_sb
	(action 0)
	?f <- (ext_SB unknown)
=>
	(printout t "Do you have external sound-card (yes/no)? ")
	(bind ?ext (lowcase (read)))
	(if (or (eq ?ext yes) (eq ?ext y)) then
		(assert (ext_SB yes))
		(inputcard [external_sb])
		(inputsb [external_sb])
	else
		(assert (ext_SB no))
	)
	(retract ?f)
)

(defrule input_external_vga
	(action 0)
	?f <- (ext_VGA unknown)
=>
	(printout t "Do you have external video-card (yes/no)? ")
	(bind ?ext (lowcase (read)))
	(if (or (eq ?ext yes) (eq ?ext y)) then
		(assert (ext_VGA yes))
		(inputcard [external_vga])
		(inputvga [external_vga])
	else
		(assert (ext_VGA no))
	)
	(retract ?f)
)

(defrule do_print
	?f <- (action_print)
	?act <- (action ?actnum)
	(cpu.manufactor ?manufac)
	(test (neq ?manufac unknown))
	(cpu.model ?model)
	(test (neq ?model unknown))
	(cpu.socket ?socket)
	(test (neq ?socket unknown))
	(cpu.maxtech ?tech)
	(test (neq ?tech unknown))
	(cpu.threads ?trea)
	(test (neq ?trea unknown))
	(cpu.cache ?cache)
	(test (neq ?cache unknown))
	(cpu.corefreq ?freq)
	(test (neq ?freq unknown))
	(cpu.FSB ?fsb)
	(test (neq ?fsb unknown))
	(CPUs ?cpus)
	(test (neq ?cpus unknown))
	(FPU ?fpuexist)
	(test (neq ?fpuexist unknown))
	(RAM ?ram)
	(test (neq ?ram unknown))
	(hdd.manufactor ?Hmanufac)
	(test (neq ?Hmanufac unknown))
	(hdd.model ?Hmodel)
	(test (neq ?Hmodel unknown))
	(hdd.interface ?Hinterf)
	(test (neq ?Hinterf unknown))
	(hdd.maxspeed ?Hmaxspd)
	(test (neq ?Hmaxspd unknown))
	(hdd.space ?Hspace)
	(test (neq ?Hspace unknown))
	(hdd.accesstime ?Hactime)
	(test (neq ?Hactime unknown))
	(mb.chipset ?mbchip)
	(test (neq ?mbchip unknown))
	(mb.model ?mbmodel)
	(test (neq ?mbmodel unknown))
	(mb.cpusocket ?mbcpus)
	(test (neq ?mbcpus unknown))
	(mb.cpucount ?mbcpuc)
	(test (neq ?mbcpuc unknown))
	(mb.haveintvga ?mbhivga)
	(test (neq ?mbhivga unknown))
	(test (neq ?mbhivga yes))
	(mb.haveintsb ?mbhisb)
	(test (neq ?mbhisb unknown))
	(test (neq ?mbhisb yes))
	(mb.haveintdc ?mbhidc)
	(test (neq ?mbhidc unknown))
	(test (neq ?mbhidc yes))
	(knownmbslots yes)
	(ext_DC ?extdc)
	(test (neq ?extdc unknown))
	(ext_SB ?extsb)
	(test (neq ?extsb unknown))
	(ext_VGA ?extvga)
	(test (neq ?extvga unknown))
=>
	(facts)
	(t40)
	;--------------------------------------------------------
	(printout t "MOTHERBOARD:" crlf)
	(printout t "Chipset: " ?mbchip crlf)
	(printout t "Slots for cards:")
	(bind ?sc (send [MB.extslots.all] get-PCI))
	(if (= ?sc 0) then (printout t " noPCI"))
	(if (> ?sc 0) then (printout t " " ?sc "xPCI"))
	(bind ?sc (send [MB.extslots.all] get-PCIE))
	(if (= ?sc 0) then (printout t " noPCIE"))
	(if (> ?sc 0) then (printout t " " ?sc "xPCIE"))
	(bind ?sc (send [MB.extslots.all] get-PCIEG))
	(if (= ?sc 0) then (printout t " noPCIEG"))
	(if (> ?sc 0) then (printout t " " ?sc "xPCIEG"))
	(bind ?sc (send [MB.extslots.all] get-ISA))
	(if (= ?sc 0) then (printout t " noISA"))
	(if (> ?sc 0) then (printout t " " ?sc "xISA"))
	(bind ?sc (send [MB.extslots.all] get-AGP))
	(if (= ?sc 0) then (printout t " noAGP"))
	(if (> ?sc 0) then (printout t " " ?sc "xAGP"))
	(bind ?sc (send [MB.extslots.all] get-VESA))
	(if (= ?sc 0) then (printout t " noVESA"))
	(if (> ?sc 0) then (printout t " " ?sc "xVESA"))
	(printout t crlf)
	(printout t "Slots for memory:")
	(bind ?sc (send [MB.memslots.all] get-SIMM))
	(if (= ?sc 0) then (printout t " noSIMM"))
	(if (> ?sc 0) then (printout t " " ?sc "xSIMM"))
	(bind ?sc (send [MB.memslots.all] get-SDR_DIMM))
	(if (= ?sc 0) then (printout t " noDIMM"))
	(if (> ?sc 0) then (printout t " " ?sc "xDIMM"))
	(bind ?sc (send [MB.memslots.all] get-DDR_DIMM))
	(if (= ?sc 0) then (printout t " noDDR"))
	(if (> ?sc 0) then (printout t " " ?sc "xDDR"))
	(bind ?sc (send [MB.memslots.all] get-DDR2_DIMM))
	(if (= ?sc 0) then (printout t " noDDR2"))
	(if (> ?sc 0) then (printout t " " ?sc "xDDR2"))
	(bind ?sc (send [MB.memslots.all] get-RIMM))
	(if (= ?sc 0) then (printout t " noRIMM"))
	(if (> ?sc 0) then (printout t " " ?sc "xRIMM"))
	(printout t crlf)
	(if (eq ?mbhidc yes!) then
		(printout t "Integrated disk controller:" crlf)
		(printdc [MB.intdc])
	)
	(if (eq ?mbhivga yes!) then
		(printout t "Integrated video-adapter:" crlf)
		(printvga [MB.intvga])
	)
	(if (eq ?mbhisb yes!) then
		(printout t "Integrated sound-blaster:" crlf)
		(printsb [MB.intsb])
	)
	(printout t crlf)
	;--------------------------------------------------------
	(printout t "SYSTEM:" crlf)
	(if (> ?cpus 1) then (printout t ?cpus "x"))
	(printout t "CPU: " ?manufac " " ?model " " ?freq "MHz" crlf)
	(printout t " - support " ?tech " instructions" crlf)
	(printout t " - system bus: " ?fsb " MB/s" crlf)
	(printout t " - " ?socket " processor" crlf)
	(printout t " - cache: ")
	(if (eq ?cache 1) then
		(printout t "1 level" crlf)
	else
		(printout t ?cache " levels" crlf)
	)
	(if (eq ?mbhivga yes!) then
		(printout t "RAM: " ?ram "(" (- ?ram (send [MB.intvga] get-memory)) ") MB" crlf)		
	else
		(printout t "RAM: " ?ram " MB" crlf)
	)
	(printout t "HDD: " ?Hmanufac " " ?Hmodel crlf)
	(printout t " - space: " ?Hspace " GB" crlf)
	(printout t " - interface: " ?Hinterf crlf)
	(printout t " - maximum speed: " ?Hmaxspd " MB/s" crlf)
	(printout t " - average seek time: " ?Hactime " ms" crlf)
	(if (eq ?extdc yes) then
		(printout t "External disk controller:" crlf)
		(printcard [external_dc])
		(printdc [external_dc])
	)
	(if (eq ?extsb yes) then
		(printout t "External sound-card:" crlf)
		(printcard [external_sb])
		(printsb [external_sb])
	)
	(if (eq ?extvga yes) then
		(printout t "External video-card:" crlf)
		(printcard [external_vga])
		(printvga [external_vga])
	)
	(printout t crlf)
	;--------------------------------------------------------
	(assert (knownconfiguration))
	(assert (action_selection))
	(retract ?f)
)

(defrule do_analysis
	?f <- (action_analysis)
	?act <- (action ?actnum)
	(cpu.manufactor ?manufac)
	(cpu.model ?model)
	(cpu.socket ?socket)
	(cpu.maxtech ?tech)
	(cpu.threads ?trea)
	(cpu.cache ?cache)
	(cpu.corefreq ?freq)
	(cpu.FSB ?fsb)
	(CPUs ?cpus)
	(FPU ?fpuexist)
	(RAM ?ram)
	(hdd.manufactor ?Hmanufac)
	(hdd.model ?Hmodel)
	(hdd.interface ?Hinterf)
	(hdd.maxspeed ?Hmaxspd)
	(hdd.space ?Hspace)
	(hdd.accesstime ?Hactime)
	(mb.chipset ?mbchip)
	(mb.model ?mbmodel)
	(mb.cpusocket ?mbcpus)
	(mb.cpucount ?mbcpuc)
	(mb.haveintvga ?mbhivga)
	(mb.haveintsb ?mbhisb)
	(mb.haveintdc ?mbhidc)
	(ext_DC ?extdc)
	(ext_SB ?extsb)
	(ext_VGA ?extvga)
=>
	(t40)
	(if (eq ?mbhivga yes!) then
		(printout t "Memory, used for integrated videoadapter (0-")
		(printout t (send [MB.intvga] get-memory) "), MB: ")
		(bind ?vidmem (read))
		(printout t crlf crlf)
	else
		(bind ?vidmem 0)
	)
	(if (eq ?cpus 1) then (printout t "CPU") else (printout t "CPUs"))
	(printout t ": " ?manufac " " ?model " " ?freq "MHz (" ?tech)
	(if (eq ?fpuexist yes) then (printout t ", FPU"))
	(printout t ")" crlf)
	(printout t "Threads simultaneously: " (* ?cpus ?trea) crlf)
	(bind ?sysram (- ?ram ?vidmem))
	(printout t "Available physical memory: " ?sysram " MB" crlf)
	(printout t "Real space on hard disk: ~" (/ ?Hspace 1.07374) " GB" crlf)
	(printout t crlf)
	(bind ?busypci 0)
	(if (eq (send [external_dc] get-card_slot) PCI) then (bind ?busypci (+ ?busypci 1)))
	(if (eq (send [external_sb] get-card_slot) PCI) then (bind ?busypci (+ ?busypci 1)))
	(if (eq (send [external_vga] get-card_slot) PCI) then (bind ?busypci (+ ?busypci 1)))
	(send [MB.extslots.free] put-PCI (- (send [MB.extslots.all] get-PCI) ?busypci))
	(send [MB.extslots.free] put-PCIE (send [MB.extslots.all] get-PCIE))
	(send [MB.extslots.free] put-PCIEG (send [MB.extslots.all] get-PCIEG))
	(send [MB.extslots.free] put-ISA (send [MB.extslots.all] get-ISA))
	(send [MB.extslots.free] put-AGP (send [MB.extslots.all] get-AGP))
	(send [MB.extslots.free] put-VESA (send [MB.extslots.all] get-VESA))
	(printout t "Free slots for cards (maximum):" crlf)
	(bind ?sc (send [MB.extslots.free] get-PCI))
	(if (> ?sc 0) then (printout t " - " ?sc "xPCI" crlf))
	(bind ?sc (send [MB.extslots.free] get-PCIE))
	(if (> ?sc 0) then (printout t " - " ?sc "xPCIE" crlf))
	(bind ?sc (send [MB.extslots.free] get-PCIEG))
	(if (> ?sc 0) then (printout t " - " ?sc "xPCIEG" crlf))
	(bind ?sc (send [MB.extslots.free] get-ISA))
	(if (> ?sc 0) then (printout t " - " ?sc "xISA" crlf))
	(bind ?sc (send [MB.extslots.free] get-AGP))
	(if (> ?sc 0) then (printout t " - " ?sc "xAGP" crlf))
	(bind ?sc (send [MB.extslots.free] get-VESA))
	(if (> ?sc 0) then (printout t " - " ?sc "xVESA" crlf))
	(printout t " - ..." crlf)
	(printout t crlf)
	(printout t "Warnings: " crlf)
	(if (and (eq ?mbhidc no) (eq ?extdc no)) then
		(printout t " - disk controller is absent" crlf)
	)
	(if (and
		(or (eq ?mbhidc no) (neq (send [MB.intdc] get-interface) ?Hinterf))
		(or (eq ?extdc no) (neq (send [external_dc] get-interface) ?Hinterf)))
	then
		(printout t " - apropriate controller for hard disk is absent" crlf)
	else
		(if (and
			(or (eq ?mbhidc no) (< (send [MB.intdc] get-maxspeed) ?Hmaxspd) (neq (send [MB.intdc] get-interface) ?Hinterf))
			(or (eq ?extdc no) (< (send [external_dc] get-maxspeed) ?Hmaxspd) (neq (send [external_dc] get-interface) ?Hinterf)))
		then
			(printout t " - controller is too slow for hard disk" crlf)
		)
	)
	(if (and (or (eq ?mbhivga no) (<= ?vidmem 0)) (eq ?extvga no)) then
		(printout t " - videoadapter is absent" crlf)
	else
		(if (and
			(or (eq ?mbhivga no) (eq (send [MB.intvga] get-support2D) no) (<= ?vidmem 0))
			(or (eq ?extvga no) (eq (send [external_vga] get-support2D) no)))
		then
			(printout t " - videoadapter do not support 2D-modes" crlf)
		)
	)
	(if (or (<= ?sysram ?vidmem) (< ?sysram 1)) then (printout t " - too few available physical memory" crlf))
	(printout t crlf)
	(assert (action_selection))
	(retract ?f)
)

(defrule do_advices
	?f <- (action_advices)
	?act <- (action ?actnum)
=>
	(t40)
	(printout t "What do you want improve (stability, performance)? ")
	(bind ?impr (lowcase (read)))
	(assert (advice ?impr))
	(if (and (neq ?impr stability) (neq ?impr performance)) then (assert (advice finish)))
	(assert (action_selection))
	(retract ?f)
)

(defrule do_advice_stab
	?f <- (advice stability)
	(hdd.interface ?Hinterf)
	(hdd.maxspeed ?Hmaxspd)
	(mb.haveintdc ?mbhidc)
	(ext_DC ?extdc)
=>
	(printout t "Stability advices:" crlf)
	(if (or
		(and (neq ?mbhidc no) (eq (send [MB.intdc] get-interface) ?Hinterf) (eq (send [MB.intdc] get-raid1) yes))
		(and (neq ?extdc no) (eq (send [external_dc] get-interface) ?Hinterf) (eq (send [external_dc] get-raid1) yes))
	) then
		(printout t " - add hard disk(s) and use RAID1" crlf)
	)
	(printout t " - verify, are CPU and RAM overclocked?" crlf)
	(printout t " - verify, are videoadapters overclocked?" crlf)
	(printout t crlf)
	(retract ?f)
	(assert (advice finish))
)

(defrule do_advice_perf
	?f <- (advice performance)
	(CPUs ?cpus)
	(FPU ?fpuexist)
	(RAM ?ram)
	(hdd.interface ?Hinterf)
	(hdd.maxspeed ?Hmaxspd)
	(mb.cpucount ?mbcpuc)
	(mb.haveintvga ?mbhivga)
	(mb.haveintsb ?mbhisb)
	(mb.haveintdc ?mbhidc)
	(ext_DC ?extdc)
	(ext_SB ?extsb)
	(ext_VGA ?extvga)
=>
	(printout t "Performance advices: " crlf)
	(if (or
		(and (neq ?mbhidc no) (eq (send [MB.intdc] get-interface) ?Hinterf) (eq (send [MB.intdc] get-raid0) yes))
		(and (neq ?extdc no) (eq (send [external_dc] get-interface) ?Hinterf) (eq (send [external_dc] get-raid0) yes))
	) then
		(printout t " - add hard disk(s) and use RAID0" crlf)
	)
	(if (< ?cpus ?mbcpuc) then (printout t " - add processor(s) and use SMP" crlf))
	(if (= ?mbcpuc 1) then (printout t " - upgrade processor (no sure)" crlf))
	(printout t " - increase memory (RAM)" crlf)
	(if (and
		(or (eq ?mbhisb no) (eq (send [MB.intsb] get-support3D) no))
		(or (eq ?extsb no) (eq (send [external_sb] get-support3D) no))
	) then
		(printout t " - install card with hardware 3D-sound" crlf)
	)
	(if (and
		(or (eq ?mbhivga no) (eq (send [MB.intvga] get-support3D) no))
		(or (eq ?extvga no) (eq (send [external_vga] get-support3D) no))
	) then
		(printout t " - install 3D-accelerator" crlf)
	)
	(if (and
		(or (eq ?mbhidc no) (< (send [MB.intdc] get-maxspeed) ?Hmaxspd) (neq (send [MB.intdc] get-interface) ?Hinterf))
		(or (eq ?extdc no) (< (send [external_dc] get-maxspeed) ?Hmaxspd) (neq (send [external_dc] get-interface) ?Hinterf)))
	then
		(printout t " - upgrade disk controller" crlf)
	)
	(printout t crlf)
	(retract ?f)
	(assert (advice finish))
)

(defrule do_selection
	?f <- (action_selection)
	?adv <- (advice finish)
	?act <- (action ?actnum)
	(knownconfiguration)
=>
	(retract ?f)
	(retract ?act)
	(printout t t "What do you want (print, analysis, advices, exit)? ")
	(bind ?action (lowcase (read)))
	(if (eq ?action analysis) then
		(assert (action_analysis))
		(assert (action (+ ?actnum 1)))
	else
		(if (eq ?action advices) then
			(assert (action_advices))
			(assert (action (+ ?actnum 1)))
			(retract ?adv)
		else
			(if (eq ?action print) then
				(assert (action_print))
				(assert (action (+ ?actnum 1)))
			else
				(if (neq ?action exit) then
					(assert (action 1))
					(assert (action_selection))
				)
			)
		)
	)
)
