Attribute VB_Name = "modClass"
Public Const NBm = 0.1
Public Const FAtrs = 16
Public Const MaxFind = 100
Public Const MaxTarget = 32
Public Const MaxDiff = 100
Public Const MaxValue = 255

Type DIFF_TARGET
    Value As String
    Count As Long
End Type

Type EXAMPLE_DATA
    AttrValue(1 To FAtrs + MaxFind) As Long
    Target As String
    Exist As Boolean
End Type

Public FindAtrs(1 To MaxFind) As String, FindCount As Long
Public TargetID(1 To MaxTarget) As String, TargetName(1 To MaxTarget) As String
Public TargetMethod(1 To MaxTarget) As String, TargetCount As Long
Public FA(1 To FAtrs + MaxFind) As Byte, AttrCount As Long
Public AttrExist(1 To FAtrs + MaxFind) As Boolean
Public AttrRegName(1 To FAtrs + MaxFind) As String
Public Example() As EXAMPLE_DATA, RegExamples As Long, Examples As Long
Public DiffTarget(1 To MaxDiff) As DIFF_TARGET, DiffCount As Long
Public TargetProb(1 To MaxDiff) As Double, dtg As DIFF_TARGET
Public TargetsInCombo(1 To MaxDiff) As String, ForJoin(MaxValue) As Long

Public Function KnowFileAttributes(FN As String) As Boolean
    Dim hFile As Long, pp As Long, sp As Long, f As Byte, b As Boolean
    Dim i As Long, j As Long, l As Long, ret As Long, s As String
    pp = InStrRev(FN, ".")
    sp = InStrRev(FN, "\")
    If sp <= 0 Or pp <= 0 Or pp >= Len(FN) Then KnowFileAttributes = False: Exit Function
    hFile = CreateFile(FN, GENERIC_READ, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0)
    If hFile = INVALID_HANDLE_VALUE Then KnowFileAttributes = False: Exit Function
    FileSize = GetFileSize(hFile, ret)
    If FileSize < 1024 Then
        f = 1
    ElseIf FileSize < 10240 Then
        f = 2
    ElseIf FileSize < 102400 Then
        f = 3
    ElseIf FileSize < 1048576 Then
        f = 4
    ElseIf FileSize < 10485760 Then
        f = 5
    ElseIf FileSize < 104857600 Then
        f = 6
    ElseIf FileSize < 2 ^ 30 Then
        f = 7
    Else
        f = 8
    End If
    FullFileSize = FileSize
    If FileSize > MAX_FILE_SIZE Or ret <> 0 Then FileSize = MAX_FILE_SIZE
    If FullFileSize > MAX_FULL_FILE_SIZE Or ret <> 0 Then FullFileSize = MAX_FULL_FILE_SIZE
    If FullFileSize > FileSize Then
        ReadFile hFile, FileData(0), (FileSize + 1) \ 2, ret, 0
        SetFilePointer hFile, FileSize \ 2 + 1 + FullFileSize - FileSize, 0, FILE_BEGIN
        ReadFile hFile, FileData(FileSize \ 2 + 1), (FileSize + 1) \ 2, ret, 0
    Else
        ReadFile hFile, FileData(0), FileSize, FileSize, 0
    End If
    ret = GetFileInformationByHandle(hFile, FileInfo)
    If ret = 0 Then
        For i = 10 To 15: FA(i) = 0: Next
    Else
        ret = FileTimeToSystemTime(FileInfo.ftLastWriteTime, FileDate)
        FA(10) = FileDate.wDay
        FA(11) = FileDate.wMonth
        FA(12) = FileDate.wYear - 1900
        FA(13) = FileDate.wDayOfWeek
        If FA(13) = 0 Then FA(13) = 7
        If FileDate.wHour >= 4 Then
            If FileDate.wHour >= 10 Then
                If FileDate.wHour >= 16 Then
                    If FileDate.wHour < 22 Then
                        FA(15) = 4
                    Else
                        FA(15) = 1
                    End If
                Else
                    FA(15) = 3
                End If
            Else
                FA(15) = 2
            End If
        Else
            FA(15) = 1
        End If
        FA(14) = 2 - Sgn(FILE_ATTRIBUTE_SYSTEM And FileInfo.dwFileAttributes)
    End If
    CloseHandle hFile
    FA(8) = f
    s = LCase(Mid(FN, pp + 1))
    Select Case s
    Case "exe"
        FA(1) = 1
    Case "com"
        FA(1) = 2
    Case "scr"
        FA(1) = 3
    Case Else
        FA(1) = 4
    End Select
    FA(2) = pp - sp - 1
    s = LCase(Mid(FN, sp + 1, FA(2)))
    Select Case Left(s, 1)
    Case "s", "i"
        FA(3) = 4
    Case "~"
        FA(3) = 5
    Case Else
        f = Asc(Left(s, 1))
        If f >= 48 And f <= 57 Then
            FA(3) = 3
        ElseIf f >= 97 And f <= 122 Then
            FA(3) = 1
        ElseIf f >= 224 Then
            FA(3) = 2
        Else
            FA(3) = 6
        End If
    End Select
    For i = 4 To 7: FA(i) = 2: Next
    For i = 1 To FA(2)
        f = Asc(Mid(s, i, 1))
        If f >= 48 And f <= 57 Then
            FA(4) = 1
        ElseIf f >= 224 Then
            FA(5) = 1
        ElseIf f >= 97 And f <= 122 Then
            FA(7) = 1
        Else
            If f <> 126 Then FA(6) = 1
        End If
    Next
    FA(9) = 0
    If WinVer > 0 Then
        ret = GetBinaryType(FN, i)
        If ret = 0 Then FA(9) = 4 Else FA(9) = i + 1
    End If
    ReDim m(2) As Byte
    m(0) = &HCD
    m(1) = &H33
    l = FindInFile(m, 2, FileData)
    FA(16) = 2
    If l <> -1 Then
        b = False
        For i = 1 To 5
            b = b Or FileData(l - i) = &HB8 Or FileData(l - i) = &HEB
        Next
        If b Then FA(16) = 1
    End If
    For i = 0 To FileSize - 1
        FileDataL(i) = Asc(LCase(Chr(FileData(i))))
    Next
    For i = 1 To FindCount
        s = FindAtrs(i)
        l = Len(s)
        ReDim m(l) As Byte
        For j = 1 To l
            m(j - 1) = Asc(LCase(Mid(s, j, 1)))
        Next
        m(l) = 0
        FA(FAtrs + i) = IIf(FindInFile(m, l, FileDataL) = -1, 2, 1)
    Next
    FirstClass = True
    KnowFileAttributes = True
End Function

Function FindInFile(m() As Byte, n As Long, filearr() As Byte) As Long
    Dim i As Long, j As Long, b As Byte
    b = m(0)
    For i = 0 To FileSize - n
        If b = filearr(i) Then
            For j = 1 To n - 1
                If m(j) <> filearr(i + j) Then GoTo l1
            Next
            FindInFile = i
            Exit Function
        End If
l1:
    Next
    FindInFile = -1
End Function

Function EqualStrings(s1 As String, s2 As String) As Boolean
    EqualStrings = LCase(Trim(s1)) = LCase(Trim(s2))
End Function

Function Entropy(Optional AttrNum As Long = 0, Optional AttrVal As Long = 0) As Double
    Dim i As Long, j As Long, s As String, b As Boolean
    Dim p As Double, entr As Double, dt As DIFF_TARGET
    DiffCount = 0
    For i = Examples To 1 Step -1
        If AttrNum < 1 Or AttrVal < 1 Then b = True Else b = Example(i).AttrValue(AttrNum) = AttrVal
        If Example(i).Exist And b Then
            s = Example(i).Target
            b = False
            For j = 1 To DiffCount
                If EqualStrings(s, DiffTarget(j).Value) Then b = True: Exit For
            Next
            If b Then
                DiffTarget(j).Count = DiffTarget(j).Count + 1
            Else
                DiffCount = DiffCount + 1
                DiffTarget(DiffCount).Value = s
                DiffTarget(DiffCount).Count = 1
            End If
        End If
    Next
    For i = 2 To DiffCount
        For j = 1 To i - 1
            If DiffTarget(i).Count > DiffTarget(j).Count Then
                dt = DiffTarget(i): DiffTarget(i) = DiffTarget(j): DiffTarget(j) = dt
            End If
        Next
    Next
    On Local Error Resume Next
    entr = 0
    If DiffCount > 1 Then
        For i = 1 To DiffCount
            p = DiffTarget(i).Count / Examples
            entr = entr - p * Log(p) / Log(DiffCount)
        Next
    End If
    Entropy = entr
End Function
