//
//  UIView+APViewCategory.m
//
//  Created by Oleksandr Prosin on 29.08.11.
//

#import "UIView+APViewCategory.h"

#import "NSString+APStringCategory.h"

#import <QuartzCore/QuartzCore.h>

#define COORD_ALIGN(x) (([[UIScreen mainScreen] scale]!=2)?floor(x):(([[UIScreen mainScreen] scale]==2)?(floor(2*x)/2.):x))

static NSDate* animationEndsTime = nil;

@implementation UIView (APViewCategory)

- (id)initVerticalLineWithLength:(CGFloat)length x:(CGFloat)x y:(CGFloat)y color:(UIColor*)color {
    self = [self initWithFrame:CGRectMake(x, y, 1, length)];
    self.backgroundColor = color;
    return self;
}

- (id)initHorizontalLineWithLength:(CGFloat)length x:(CGFloat)x y:(CGFloat)y color:(UIColor*)color {
    self = [self initWithFrame:CGRectMake(x, y, length, 1)];
    self.backgroundColor = color;
    return self;
}

- (void)moveDx:(CGFloat)dx dy:(CGFloat)dy {
    //[self setFrame:CGRectMake(self.frame.origin.x+dx, self.frame.origin.y+dy, self.frame.size.width, self.frame.size.height)];
    [self setCenter:CGPointMake(self.center.x+dx, self.center.y+dy)];
}

- (NSMutableArray*)removeSubviewsWithTag:(NSInteger)tag {
    NSMutableArray* result = [NSMutableArray new];
    for (UIView* item in [self subviews])
        if (item.tag==tag||tag==NSNotFound) {
            [result addObject:item];
        }
    for (UIView* item in result) {
        [item removeFromSuperview];
    }
    return [result autorelease];
}

- (void)bringToFront {
    [self.superview bringSubviewToFront:self];
}

- (void)sendToBack {
    [self.superview sendSubviewToBack:self];
}

- (void)setHeight:(CGFloat)height {
    [self setFrame:CGRectMake(self.frame.origin.x, self.frame.origin.y, self.frame.size.width, height)];
}

- (CGFloat)height {
    return self.frame.size.height;
}

- (void)setWidth:(CGFloat)width {
    [self setFrame:CGRectMake(self.frame.origin.x, self.frame.origin.y, width, self.frame.size.height)];
}

- (CGFloat)width {
    return self.frame.size.width;
}

- (void)setLeft:(CGFloat)left {
    [self setFrame:CGRectMake(left, self.frame.origin.y, self.frame.size.width, self.frame.size.height)];
}

- (CGFloat)left {
    return self.frame.origin.x;
}

- (void)setTop:(CGFloat)top {
    [self setFrame:CGRectMake(self.frame.origin.x, top, self.frame.size.width, self.frame.size.height)];
}

- (CGFloat)top {
    return self.frame.origin.y;
}

- (CGFloat)right {
    return self.frame.origin.x + self.frame.size.width;
}

- (CGFloat)bottom {
    return self.frame.origin.y + self.frame.size.height;
}

- (CGRect)internalFrame {
    return CGRectMake(0, 0, self.width, self.height);
}

- (void)setVisible:(BOOL)visible {
    self.hidden = !visible;
}

- (BOOL)visible {
    return !self.hidden;
}

- (void)setRecurrentOpaque {
    self.opaque = YES;
    for (UIView* v in self.subviews) {
        [v setRecurrentOpaque];
    }
}

- (void)setImage:(UIImage*)img forStates:(UIControlState)mask {
    if ([self isKindOfClass:[UIButton class]]) {
        UIButton* button = (UIButton*)self;
        [button setImage:img forState:UIControlStateNormal];
        if (mask&UIControlStateHighlighted) [button setImage:img forState:UIControlStateHighlighted];
        if (mask&UIControlStateDisabled) [button setImage:img forState:UIControlStateDisabled];
        if (mask&UIControlStateSelected) [button setImage:img forState:UIControlStateSelected];
    } else if ([self isKindOfClass:[UIImageView class]]) {
        [(UIImageView*)self setImage:img];
    }
}

- (UIImage*)sharpSnapshot {
    CGFloat scale = [[UIScreen mainScreen] scale];
    if (scale==1) return [self snapshot];
    //вроде как UIGraphicsBeginImageContextWithOptions в iOS 6 может создавать утечку, при частом использовании на больших картинках лучше переделать
    if ([self isKindOfClass:[UIScrollView class]]) {
        UIGraphicsBeginImageContextWithOptions((((UIScrollView*)self).contentSize), NO, scale);
        [self.layer renderInContext:UIGraphicsGetCurrentContext()];
    } else {
        UIGraphicsBeginImageContextWithOptions(self.bounds.size, NO, scale);
        /*if ([self respondsToSelector:@selector(drawViewHierarchyInRect:afterScreenUpdates:)]) {
            [self drawViewHierarchyInRect:self.bounds afterScreenUpdates:YES];
        } else*/ {
            [self.layer renderInContext:UIGraphicsGetCurrentContext()];
        }
    }
    UIImage *viewImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return viewImage;
}

- (UIImage*)snapshot {
    CGSize sz = self.bounds.size;
    UIGraphicsBeginImageContext(sz);
    if ([self isKindOfClass:[UIScrollView class]]) {
        UIScrollView* scrollView = (UIScrollView*)self;
        CGPoint offset = scrollView.contentOffset;
        CGContextTranslateCTM(UIGraphicsGetCurrentContext(), -offset.x, -offset.y);
    }
    [self.layer renderInContext:UIGraphicsGetCurrentContext()];
    UIImage *viewImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return viewImage;
}

- (UIView*)copy {
    UIImageView* result = [[UIImageView alloc] initWithFrame:self.frame];
    result.hidden = self.hidden;
    result.backgroundColor = self.backgroundColor;
    result.image = [self snapshot];
    return result;
}

- (UIView*)sharpCopy {
    UIImageView* result = [[UIImageView alloc] initWithFrame:self.frame];
    result.hidden = self.hidden;
    result.backgroundColor = self.backgroundColor;
    result.image = [self sharpSnapshot];
    return result;
}

- (UIView*)sharpCopyWithOffset:(CGPoint)offset {
    CGRect fr = self.frame;
    fr.origin.x += offset.x;
    fr.origin.y += offset.y;
    UIImageView* result = [[UIImageView alloc] initWithFrame:fr];
    result.hidden = self.hidden;
    result.backgroundColor = self.backgroundColor;
    result.image = [self sharpSnapshot];
    return result;
}

- (UIView*)createCopyOnSameSuperview {
    if (self.superview==nil) return nil;
    //NSDate* d = [NSDate now];
    UIView* result = nil;
    if ([self respondsToSelector:@selector(snapshotViewAfterScreenUpdates:)]) {
        BOOL b = YES;
        if ([self isKindOfClass:[UIScrollView class]]) {
            UIScrollView* scroll = (UIScrollView*)self;
            if (scroll.contentSize.width!=self.width) {
                b = NO;
            }
        }
        if (b)
            result = [[self snapshotViewAfterScreenUpdates:NO] retain];
    }
    if (result==nil) result = [self copy];
    //NSLog(@"%f", -[d timeIntervalSinceNow]);
    [self.superview addSubview:result];
    [result release];
    return result;
}

- (void)initiateFade {
    UIView* viewForFade = [self copy];
    viewForFade.backgroundColor = [UIColor clearColor];
    [self addSubview:viewForFade];
    viewForFade.alpha = 1;
    [self performSelector:@selector(continueFade:) withObject:viewForFade afterDelay:0];
    [viewForFade release];
}

- (void)continueFade:(UIView*)viewForFade {
    [UIView beginAnimations];
    viewForFade.alpha = 0;
    [UIView commitAnimations];
    [viewForFade performSelector:@selector(removeFromSuperview) afterDelay:1+UINavigationControllerHideShowBarDuration];
}

+ (void)beginAnimations {
    CGFloat duration = UINavigationControllerHideShowBarDuration;
    [UIView beginAnimations:nil context:nil];
    [UIView setAnimationDuration:duration];
    [animationEndsTime release];
    animationEndsTime = [[[NSDate date] dateByAddingTimeInterval:1+duration] retain];
}

+ (BOOL)animationInProgress {
    if (animationEndsTime==nil) {
        return NO;
    }
    NSDate* now = [NSDate date];
    NSComparisonResult result = [animationEndsTime compare:now];
    return result!=NSOrderedAscending;
}

- (void) animateFromOffset:(CGPoint)offset fade:(BOOL)fade {
    CGFloat left = self.left;
    CGFloat top = self.top;
    CGFloat alpha;
    self.left += offset.x;
    self.top += offset.y;
    if (fade) {
        alpha = self.alpha;
        self.alpha = 0;
    }
    [UIView beginAnimations];
    //[UIView beginAnimations:nil context:nil];
    //[UIView setAnimationDuration:UINavigationControllerHideShowBarDuration];
    //[UIView setAnimationDuration:1];
    self.left = left;
    self.top = top;
    if (fade) self.alpha = alpha;
    [UIView commitAnimations];
}

/*- (void) animateFromOffset:(CGPoint)offset contentOffsetOffset:(CGPoint)contentOffsetOffset {
    CGFloat left = self.left;
    CGFloat top = self.top;
    CGFloat alpha;
    self.left += offset.x;
    self.top += offset.y;
    CGPoint co
    if (fade) {
        alpha = self.alpha;
        self.alpha = 0;
    }
    [UIView beginAnimations];
    //[UIView beginAnimations:nil context:nil];
    //[UIView setAnimationDuration:UINavigationControllerHideShowBarDuration];
    //[UIView setAnimationDuration:1];
    self.left = left;
    self.top = top;
    if (fade) self.alpha = alpha;
    [UIView commitAnimations];
}*/

- (void) animateFromOffset:(CGPoint)offset insteadView:(UIView*)otherView {
    CGFloat left = self.left;
    CGFloat top = self.top;
//    CGFloat alpha;
    self.left += offset.x;
    self.top += offset.y;
//    if (fade) {
//        alpha = self.alpha;
//        self.alpha = 0;
//    }
    [UIView beginAnimations];
    //[UIView beginAnimations:nil context:nil];
    //[UIView setAnimationDuration:UINavigationControllerHideShowBarDuration];
    //[UIView setAnimationDuration:1];
    self.left = left;
    self.top = top;
    [otherView moveDx:-offset.x dy:-offset.y];
//    if (fade) self.alpha = alpha;
    [UIView commitAnimations];
}

- (BOOL)touchedByTouch:(UITouch*)touch {
    CGPoint p = [touch locationInView:self];
    CGRect bounds = self.bounds;
    return CGRectContainsPoint(bounds, p);
}

- (UIScrollView*)findScrollViewThatScrollsToTop {
    UIScrollView* v = (UIScrollView*)self;
    if ([v isKindOfClass:[UIScrollView class]]) {
        if (v.scrollsToTop) return v;
    }
    for (UIScrollView* vv in self.subviews) {
        v = [vv findScrollViewThatScrollsToTop];
        if (v) return v;
    }
    return nil;
}

- (UIView*)findViewWithOccurenceInClassName:(NSString*)part {
    NSString* className = NSStringFromClass([self class]);
    //NSLog(@"%@", className);
    if ([className rangeOfString:part].length>0) {
        return self;
    }
    UIView* r = nil;
    for (UIView* vv in self.subviews) {
        r = [vv findViewWithOccurenceInClassName:part];
        if (r) break;
    }
    return r;
}

@end


@implementation UILabel (APViewCategory)

- (void)sharp {
    self.height = floor(self.height/2)*2;
}

- (void)setTextAfterVerticalAlign:(NSString*)labelText
{
    CGSize sizeOnSingleLine = [labelText fixedSizeWithFont:self.font];
    CGSize sizeOnMultipleLines = [labelText fixedSizeWithFont:self.font constrainedToSize:self.superview.frame.size lineBreakMode:self.lineBreakMode];
    
    CGFloat height;
    if(sizeOnMultipleLines.height>sizeOnSingleLine.height)
        height = sizeOnSingleLine.height*floor(sizeOnMultipleLines.height/sizeOnSingleLine.height); //*self.numberOfLines;
    else
        height = sizeOnSingleLine.height;
    
    self.text = labelText;
    /*if ([UIView animationInProgress])
        height = height; //[self performSelector:@selector(setHeightWithObject:) withObject:[NSNumber numberWithFloat:height] afterDelay:UINavigationControllerHideShowBarDuration];
    else*/
        self.height = COORD_ALIGN(height);
    
}

- (void)setHeightWithObject:(NSNumber*)height {
    self.height = [height floatValue];
}

@end


@implementation UIButton (APViewCategory)

+ (BOOL)isFlat {
#ifdef __IPHONE_7_0
    if ([[UIDevice currentDevice] systemVersion].integerValue>=7) {
        return YES;
    }
#endif
    return NO;
}

- (void)setTitle:(NSString *)title {
    if ([self isFlat])
        [UIView performWithoutAnimation:^{
            [self setTitle:title forState:UIControlStateNormal];
            [self setTitle:title forState:UIControlStateSelected];
            [self setTitle:title forState:UIControlStateHighlighted];
            [self layoutIfNeeded];
        }];
    else {
        [self setTitle:title forState:UIControlStateNormal];
        [self setTitle:title forState:UIControlStateSelected];
        [self setTitle:title forState:UIControlStateHighlighted];
    }
}

@end

@implementation UISwitch (APViewCategory)

- (void)disableWhileAnimation {
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(enable) object:nil];
    self.userInteractionEnabled = NO;
    [self performSelectorAfterAnimation:@selector(enable)];
}
- (void)enable {
    self.userInteractionEnabled = YES;
}

@end

@implementation UIEvent (APViewCategory)

- (CGPoint)touchCoordsInView:(UIView*)view {
    NSArray* arr = [self.allTouches allObjects];
    if (arr.count==0) return CGPointZero;
    return [[arr objectAtIndex:0] locationInView:view];
}

@end

@implementation UITableView (APViewCategory)

- (void)insertRowAtIndexPath:(NSIndexPath*)indexPath withRowAnimation:(UITableViewRowAnimation)animation {
    if (indexPath) [self insertRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:animation];
}
- (void)deleteRowAtIndexPath:(NSIndexPath*)indexPath withRowAnimation:(UITableViewRowAnimation)animation {
    if (indexPath) [self deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:animation];
}
- (void)reloadRowAtIndexPath:(NSIndexPath*)indexPath withRowAnimation:(UITableViewRowAnimation)animation {
    if (indexPath) [self reloadRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:animation];
}
- (void)insertSection:(NSInteger)section withRowAnimation:(UITableViewRowAnimation)animation {
    [self insertSections:[NSIndexSet indexSetWithIndex:section] withRowAnimation:animation];
}
- (void)deleteSection:(NSInteger)section withRowAnimation:(UITableViewRowAnimation)animation {
    [self deleteSections:[NSIndexSet indexSetWithIndex:section] withRowAnimation:animation];
}
- (void)reloadSection:(NSInteger)section withRowAnimation:(UITableViewRowAnimation)animation {
    [self reloadSections:[NSIndexSet indexSetWithIndex:section] withRowAnimation:animation];
}
- (void)deselectAnimated:(BOOL)animated {
    if ([self respondsToSelector:@selector(allowsMultipleSelection)]) {
        if (self.allowsMultipleSelection) {
            [self reloadData];
            /*for (int i=0; i<5; i++) {
                [self deselectRowAtIndexPath:[NSIndexPath indexPathForRow:i inSection:0] animated:animated];
            }*/
            return;
        }
    }
    /*if (self.allowsMultipleSelection) {
        [self reloadData];
    } else*/ {
        [self selectRowAtIndexPath:[NSIndexPath indexPathForRow:-1 inSection:0] animated:animated scrollPosition:UITableViewScrollPositionNone];
    }
}

@end

@implementation UITableViewCell (APViewCategory)

- (void)setZeroIndentation {
    self.indentationLevel = 0;
}

- (void)fixDisclosureIndicatorForIOS7 {
#ifndef __IPHONE_7_0
    if ([[UIDevice currentDevice] systemVersion].integerValue>=7) {
        if (self.accessoryType==UITableViewCellAccessoryDisclosureIndicator) {
            UIImageView* imgView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"arrow.png"] highlightedImage:[UIImage imageNamed:@"arrow_highlighted.png"]];
            self.accessoryView = imgView;
            [imgView release];
        }
    }
#endif
}

@end

@implementation UISegmentedControl (APViewCategory)

- (void)fixSegmentedControlForiOS7
{
#ifndef __IPHONE_7_0
    NSInteger deviceVersion = [[UIDevice currentDevice] systemVersion].integerValue;
    if(deviceVersion < 7) // If this is not an iOS 7 device, we do not need to perform these customizations.
        return;
    
    NSDictionary *attributes = [NSDictionary dictionaryWithObjectsAndKeys:
                                [UIFont boldSystemFontOfSize:12], UITextAttributeFont,
                                [UIColor whiteColor], UITextAttributeTextColor,
                                nil];
    [self setTitleTextAttributes:attributes forState:UIControlStateNormal];
    NSDictionary *highlightedAttributes = [NSDictionary dictionaryWithObject:[UIColor whiteColor] forKey:UITextAttributeTextColor];
    [self setTitleTextAttributes:highlightedAttributes forState:UIControlStateHighlighted];
    
    self.segmentedControlStyle = UISegmentedControlStyleBar;
    //self.tintColor = [UIColor colorWithRed:49.0 / 256.0 green:148.0 / 256.0 blue:208.0 / 256.0 alpha:1];
#endif
}

@end

@implementation UIApplication (APViewCategory)

- (void)showActivityNetworkActivityIndicator {
    [self setNetworkActivityIndicatorVisible:YES];
}
- (void)hideActivityNetworkActivityIndicator {
    [self setNetworkActivityIndicatorVisible:NO];
}

@end

@implementation NSObject (APViewCategory)

- (UIAlertView*)showAlertWithTitle:(NSString*)title message:(NSString*)message tag:(NSInteger)tag cancelButtonTitle:(NSString*)cancelButtonTitle otherButtonTitle:(NSString*)otherButtonTitle {
#ifndef TARGET_IS_EXTENSION
    UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:title message:message delegate:self cancelButtonTitle:cancelButtonTitle otherButtonTitles:otherButtonTitle, nil];
    alertView.tag = tag;
    [alertView show];
    return [alertView autorelease];
#else
    return nil;
#endif
}

- (UIAlertView*)showAlertWithTitle:(NSString*)title message:(NSString*)message tag:(NSInteger)tag cancelButtonTitle:(NSString*)cancelButtonTitle otherButtonTitles:(NSString*)otherButtonTitle andButtonTitle:(NSString*)otherButtonTitle2 {
#ifndef TARGET_IS_EXTENSION
    UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:title message:message delegate:self cancelButtonTitle:cancelButtonTitle otherButtonTitles:otherButtonTitle, otherButtonTitle2, nil];
    alertView.tag = tag;
    [alertView show];
    return [alertView autorelease];
#else
    return nil;
#endif
}

@end


#define SYSTEM_VERSION_LESS_THAN(v) ([[[UIDevice currentDevice] systemVersion] compare:v options:NSNumericSearch] == NSOrderedAscending)

@implementation UIViewController (FixDeprecations)

- (void)presentViewController:(UIViewController *)modalViewController animated:(BOOL)animated {
    [self presentViewController:modalViewController animated:animated completion:^(void){}];
}
- (void)dismissViewControllerAnimated:(BOOL)animated {
    [self dismissViewControllerAnimated:animated completion:^(void){}];
}

- (void)setPopoverContentSize:(CGSize)popoverContentSize {
    if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        [self setContentSizeForViewInPopover:popoverContentSize];
#pragma clang diagnostic pop
    } else {
        [self setPreferredContentSize:popoverContentSize];
    }
}
- (CGSize)popoverContentSize {
    if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        return self.contentSizeForViewInPopover;
#pragma clang diagnostic pop
    } else {
        return self.preferredContentSize;
    }
}

- (UIInterfaceOrientation)currentInterfaceOrientation {
    return self.interfaceOrientation;   //deprecated in iOS 8
}

@end

@implementation UILabel (FixDeprecations)

- (void)setMinFontSize:(CGFloat)minFontSize {
    if (SYSTEM_VERSION_LESS_THAN(@"6.0")) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        [self setMinimumFontSize:minFontSize];
#pragma clang diagnostic pop
    } else {
        [self setMinimumScaleFactor:minFontSize/self.font.pointSize];
    }
}
- (CGFloat)minFontSize {
    if (SYSTEM_VERSION_LESS_THAN(@"6.0")) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        return self.minimumFontSize;
#pragma clang diagnostic pop
    } else {
        return self.minimumScaleFactor*self.font.pointSize;
    }
}

@end

@implementation UIFont (APViewCategory)

- (void)print {
    NSLog(@"%@ %f", self.familyName, self.pointSize);
}

@end
