//
//  UIView+APViewCategory.h
//
//  Created by Oleksandr Prosin on 29.08.11.
//

#import <UIKit/UIKit.h>

#define numberWithCGFloat numberWithFloat
#define CGFloatValue floatValue

static const CGFloat AINavigationControllerSlideDuration = 0.5;

@interface UIView (APViewCategory)

- (id)initVerticalLineWithLength:(CGFloat)length x:(CGFloat)x y:(CGFloat)y color:(UIColor*)color;
- (id)initHorizontalLineWithLength:(CGFloat)length x:(CGFloat)x y:(CGFloat)y color:(UIColor*)color;
- (void)moveDx:(CGFloat)dx dy:(CGFloat)dy;
- (NSMutableArray*)removeSubviewsWithTag:(NSInteger)tag;
- (void)bringToFront;
- (void)sendToBack;

- (CGRect)internalFrame;

@property CGFloat left;
@property CGFloat top;
@property CGFloat width;
@property CGFloat height;
@property BOOL visible;

@property (readonly) CGFloat right;
@property (readonly) CGFloat bottom;

- (void)setRecurrentOpaque;
- (void)setImage:(UIImage*)img forStates:(UIControlState)mask;

- (UIImage*)snapshot;
- (UIView*)createCopyOnSameSuperview;
- (void)initiateFade;

- (UIImage*)sharpSnapshot;
- (UIView*)sharpCopy;
- (UIView*)sharpCopyWithOffset:(CGPoint)offset;

+ (void)beginAnimations;
+ (BOOL)animationInProgress;

- (void) animateFromOffset:(CGPoint)offset fade:(BOOL)fade;
- (void) animateFromOffset:(CGPoint)offset insteadView:(UIView*)otherView;

- (BOOL)touchedByTouch:(UITouch*)touch;

- (UIScrollView*)findScrollViewThatScrollsToTop;
- (UIView*)findViewWithOccurenceInClassName:(NSString*)part;

@end

@interface UILabel (APViewCategory)

- (void)sharp;
- (void)setTextAfterVerticalAlign:(NSString*)labelText;

@end

@interface UIButton (APViewCategory)

- (void)setTitle:(NSString *)title;

@end

@interface UISwitch (APViewCategory)

- (void)disableWhileAnimation;
- (void)enable;

@end

@interface UIEvent (APViewCategory)

- (CGPoint)touchCoordsInView:(UIView*)view;

@end

@interface UITableView (APViewCategory)

- (void)insertRowAtIndexPath:(NSIndexPath*)indexPath withRowAnimation:(UITableViewRowAnimation)animation;
- (void)deleteRowAtIndexPath:(NSIndexPath*)indexPath withRowAnimation:(UITableViewRowAnimation)animation;
- (void)reloadRowAtIndexPath:(NSIndexPath*)indexPath withRowAnimation:(UITableViewRowAnimation)animation;
- (void)insertSection:(NSInteger)section withRowAnimation:(UITableViewRowAnimation)animation;
- (void)deleteSection:(NSInteger)section withRowAnimation:(UITableViewRowAnimation)animation;
- (void)reloadSection:(NSInteger)section withRowAnimation:(UITableViewRowAnimation)animation;
- (void)deselectAnimated:(BOOL)animated;

@end

@interface UITableViewCell (APViewCategory)

- (void)setZeroIndentation;
- (void)fixDisclosureIndicatorForIOS7;

@end

@interface UISegmentedControl (APViewCategory)

- (void)fixSegmentedControlForiOS7;

@end

@interface UIApplication (APViewCategory)

- (void)showActivityNetworkActivityIndicator;
- (void)hideActivityNetworkActivityIndicator;

@end

@interface NSObject (APViewCategory)

- (UIAlertView*)showAlertWithTitle:(NSString*)title message:(NSString*)message tag:(NSInteger)tag cancelButtonTitle:(NSString*)cancelButtonTitle otherButtonTitle:(NSString*)otherButtonTitle;
- (UIAlertView*)showAlertWithTitle:(NSString*)title message:(NSString*)message tag:(NSInteger)tag cancelButtonTitle:(NSString*)cancelButtonTitle otherButtonTitles:(NSString*)otherButtonTitle andButtonTitle:(NSString*)otherButtonTitle2;

@end

@interface UIViewController (FixDeprecations)
- (void)presentViewController:(UIViewController *)modalViewController animated:(BOOL)animated;  //replacement for presentModalViewController:animated:
- (void)dismissViewControllerAnimated:(BOOL)animated;   //replacement for dismissModalViewControllerAnimated:
@property (nonatomic,readwrite) CGSize popoverContentSize;  //replacement for contentSizeForViewInPopover
@property(nonatomic,readonly) UIInterfaceOrientation currentInterfaceOrientation;
#ifndef __IPHONE_7_0
@property (nonatomic) CGSize preferredContentSize;
#endif
@end

@interface UILabel (FixDeprecations)
@property(nonatomic) CGFloat minFontSize;   //replacement for minimumFontSize
@end

@interface UIFont (APViewCategory)
- (void)print;
@end
