//
//  NSString+APStringCategory.m
//
//  Created by Oleksandr Prosin on 28.08.11.
//

#import "NSString+AIStringCategory.h"

#define AIString(key) NSLocalizedString(key, "")

@implementation NSString (APStringCategory)

- (NSString*) stringValue {
    return [[self copy] autorelease];
}

- (NSString*) stringWithCapitalizedFirstSymbol {
    if (self.length==0) return @"";
    return [[[self substringToIndex:1] uppercaseString] stringByAppendingString:[self substringFromIndex:1]];
}

- (NSString*) stringWithUncapitalizedFirstSymbol {
    if (self.length==0) return @"";
    return [[[self substringToIndex:1] lowercaseString] stringByAppendingString:[self substringFromIndex:1]];
}

- (NSString*) stringWithUncapitalizedFirstSymbolForSomeLanguages {
    if ([NSLocalizedString(@"LANG", nil) isEqualToString:@"ru"])
        return [self stringWithUncapitalizedFirstSymbol];
    else
        return self;
}

- (NSString*)stringByRemovingCharactersInSet:(NSCharacterSet*)charSet {
    return [[self componentsSeparatedByCharactersInSet:charSet] componentsJoinedByString:@""];
}

+ (NSString*)stringWithInteger:(int)value {
    return [NSString stringWithFormat:@"%i", value];
}

+ (NSString*)stringWithNat:(int)value {
    switch (value) {
        case 1:
            return NSLocalizedString(@"1st", nil);
        case 2:
            return NSLocalizedString(@"2nd", nil);
        case 3:
            return NSLocalizedString(@"3rd", nil);
        default:
            return [NSString stringWithFormat:NSLocalizedString(@"%ith", nil), value];
    }
}

+ (NSString*)stringWithCount:(int)count name:(NSString*)name {
    NSString* part;
    if (count==1) {
        part = AIString(name);
    } else {
        part = AIString([name stringByAppendingString:@"Rest"]);
        if ((count%100)/10!=1) {
            if(count%10==1)
                part = AIString([name stringByAppendingString:@"1"]);
            else
                if(count%10>=2 && count%10<=4)
                    part = AIString([name stringByAppendingString:@"2-4"]);
        }
    }
    return [NSString stringWithFormat:@"%i %@", count, part];
}

@end


#define SYSTEM_VERSION_LESS_THAN(v) ([[[UIDevice currentDevice] systemVersion] compare:v options:NSNumericSearch] == NSOrderedAscending)

@implementation NSString (FixDeprecations)

- (CGSize)fixedSizeWithFont:(UIFont *)font {
    if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        return [self sizeWithFont:font];
#pragma clang diagnostic pop
    } else {
        return [self sizeWithAttributes:@{NSFontAttributeName:font}];
    }
}
- (CGSize)fixedSizeWithFont:(UIFont *)font constrainedToSize:(CGSize)size {
    if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        return [self sizeWithFont:font constrainedToSize:size];
#pragma clang diagnostic pop
    } else {
        return [self boundingRectWithSize:size options:NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:font} context:nil].size;
    }
}
- (CGSize)fixedSizeWithFont:(UIFont *)font constrainedToSize:(CGSize)size lineBreakMode:(NSLineBreakMode)lineBreakMode {
    if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
        return [self sizeWithFont:font constrainedToSize:size lineBreakMode:lineBreakMode];
#pragma clang diagnostic pop
    } else {
        return [self boundingRectWithSize:size options:NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:font} context:nil].size;
    }
}

@end
