//
//  NSString+APStringCategory.h
//
//  Created by Oleksandr Prosin on 28.08.11.
//

#import <Foundation/Foundation.h>

#define LANG NSLocalizedString(@"LANG", nil)
#define IS_EQUAL_STRING_TO_STRING(S1, S2) (((S1).length==0&&(S2).length==0)||[(S1) isEqualToString:S2])
#define stringConcat(...) [@[__VA_ARGS__] componentsJoinedByString:@""]

@interface NSString (APStringCategory)

- (NSString*) stringValue;

- (NSString*) stringWithCapitalizedFirstSymbol;
- (NSString*) stringWithUncapitalizedFirstSymbol;
- (NSString*) stringWithUncapitalizedFirstSymbolForSomeLanguages;
- (NSString*)stringByRemovingCharactersInSet:(NSCharacterSet*)charSet;

+ (NSString*) stringWithInteger:(int)value;
+ (NSString*) stringWithNat:(int)value;

+ (NSString*)stringWithCount:(int)count name:(NSString*)name;

@end

@interface NSString (FixDeprecations)
- (CGSize)fixedSizeWithFont:(UIFont *)font; //replacement for sizeWithFont:
- (CGSize)fixedSizeWithFont:(UIFont *)font constrainedToSize:(CGSize)size; //replacement for sizeWithFont:constrainedToSize:
- (CGSize)fixedSizeWithFont:(UIFont *)font constrainedToSize:(CGSize)size lineBreakMode:(NSLineBreakMode)lineBreakMode; //replacement for sizeWithFont:constrainedToSize:lineBreakMode:
#ifndef __IPHONE_7_0
- (CGSize)sizeWithAttributes:(NSDictionary *)attrs;
- (CGRect)boundingRectWithSize:(CGSize)size options:(NSStringDrawingOptions)options attributes:(NSDictionary *)attributes context:(NSStringDrawingContext *)context;
#endif
@end
