//
//  EKEventStore+AIEventKitCategory.m
//
//  Created by Александр on 12.01.13.
//

#import "APEventKitCategory.h"

//#define TEST_MODE

#ifdef TEST_MODE
EKAuthorizationStatus status = EKAuthorizationStatusDenied;
#endif

@implementation EKEventStore (APEventKitCategory)

- (BOOL)requestAccessToEntityType:(EKEntityType)entityType {
    __block BOOL accessGranted = NO;
    
    if ([self respondsToSelector:@selector(requestAccessToEntityType:completion:)]) {
        dispatch_semaphore_t sema = dispatch_semaphore_create(0);
        [self requestAccessToEntityType:entityType completion:^(BOOL granted, NSError *error) {
            accessGranted = granted;
            dispatch_semaphore_signal(sema);
        }];
        dispatch_semaphore_wait(sema, DISPATCH_TIME_FOREVER);
    } else { // we're on iOS 5 or older
        accessGranted = YES;
    }
    
#ifdef TEST_MODE
    status = EKAuthorizationStatusAuthorized;
#endif
    
    return accessGranted;
}

+ (BOOL)requiresAutorization {
    return [[EKEventStore class] respondsToSelector:@selector(authorizationStatusForEntityType:)];
}

+ (EKAuthorizationStatus)autorizationStatusForCalendarEvents {
#ifdef TEST_MODE
    return status;
#endif
    if ([EKEventStore requiresAutorization]) {
        return [EKEventStore authorizationStatusForEntityType:EKEntityTypeEvent];
    } else {
        return EKAuthorizationStatusAuthorized;
    }
}

+ (EKAuthorizationStatus)autorizationStatusForReminders {
#ifdef TEST_MODE
    return status;
#endif
    if ([EKEventStore requiresAutorization]) {
        return [EKEventStore authorizationStatusForEntityType:EKEntityTypeReminder];
    } else {
        return EKAuthorizationStatusAuthorized;
    }
}

@end
